/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.clickhouse.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.clickhouse.ast.CKSelectQueryBlock;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class CKSelectParser
extends SQLSelectParser {
    public CKSelectParser(Lexer lexer) {
        super(lexer);
    }

    public CKSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser, selectListCache);
    }

    @Override
    public SQLWithSubqueryClause parseWith() {
        SQLWithSubqueryClause withQueryClause = new SQLWithSubqueryClause();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            withQueryClause.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.WITH);
        if (this.lexer.token() == Token.RECURSIVE || this.lexer.identifierEquals(FnvHash.Constants.RECURSIVE)) {
            this.lexer.nextToken();
            withQueryClause.setRecursive(true);
        }
        while (true) {
            String alias;
            SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
            entry.setParent(withQueryClause);
            SQLExpr sqlExpr = this.exprParser.expr();
            if (sqlExpr instanceof SQLIdentifierExpr) {
                alias = ((SQLIdentifierExpr)sqlExpr).getName();
                this.accept(Token.AS);
                this.accept(Token.LPAREN);
                entry.setSubQuery(this.select());
                entry.setPrefixAlias(true);
                entry.setAlias(alias);
                this.accept(Token.RPAREN);
            } else {
                entry.setExpr(sqlExpr);
                this.accept(Token.AS);
                alias = this.lexer.stringVal();
                this.lexer.nextToken();
                entry.setPrefixAlias(false);
                entry.setAlias(alias);
            }
            withQueryClause.addEntry(entry);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return withQueryClause;
    }

    @Override
    protected SQLSelectQueryBlock createSelectQueryBlock() {
        return new CKSelectQueryBlock();
    }

    @Override
    public void parseWhere(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.nextIf(Token.PREWHERE)) {
            SQLExpr preWhere = this.exprParser.expr();
            ((CKSelectQueryBlock)queryBlock).setPreWhere(preWhere);
        }
        super.parseWhere(queryBlock);
    }

    @Override
    public void parseFrom(SQLSelectQueryBlock queryBlock) {
        super.parseFrom(queryBlock);
        if (this.lexer.token() == Token.FINAL) {
            this.lexer.nextToken();
            ((CKSelectQueryBlock)queryBlock).setFinal(true);
        } else {
            ((CKSelectQueryBlock)queryBlock).setFinal(false);
        }
    }

    @Override
    protected void afterParseFetchClause(SQLSelectQueryBlock queryBlock) {
        if (queryBlock instanceof CKSelectQueryBlock) {
            CKSelectQueryBlock ckSelectQueryBlock = (CKSelectQueryBlock)queryBlock;
            if (this.lexer.token() == Token.SETTINGS) {
                this.lexer.nextToken();
                while (true) {
                    SQLAssignItem item = this.exprParser.parseAssignItem();
                    ckSelectQueryBlock.getSettings().add(item);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.token() == Token.FORMAT) {
                this.lexer.nextToken();
                ckSelectQueryBlock.setFormat(this.expr());
            }
        }
    }

    @Override
    protected void afterParseLimitClause(SQLSelectQueryBlock queryBlock) {
        if (queryBlock instanceof CKSelectQueryBlock && this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("TIES");
            ((CKSelectQueryBlock)queryBlock).setWithTies(true);
        }
    }

    @Override
    protected void parseOrderByWith(SQLSelectGroupByClause groupBy, SQLSelectQueryBlock queryBlock) {
        Lexer.SavePoint mark = this.lexer.mark();
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.CUBE)) {
            this.lexer.nextToken();
            groupBy.setWithCube(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
            this.lexer.nextToken();
            groupBy.setWithRollUp(true);
        } else if (this.lexer.identifierEquals("TOTALS")) {
            this.lexer.nextToken();
            ((CKSelectQueryBlock)queryBlock).setWithTotals(true);
        } else {
            this.lexer.reset(mark);
        }
    }

    @Override
    protected void parseAfterOrderBy(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("FILL");
            ((CKSelectQueryBlock)queryBlock).setWithFill(true);
        }
    }
}

