/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class SQLQueryExpr
extends SQLExprImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    public SQLSelect subQuery;

    public SQLQueryExpr() {
    }

    public SQLQueryExpr(SQLSelect select) {
        this.setSubQuery(select);
    }

    public SQLSelect getSubQuery() {
        return this.subQuery;
    }

    public void setSubQuery(SQLSelect subQuery) {
        if (subQuery != null) {
            subQuery.setParent(this);
        }
        this.subQuery = subQuery;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this) && this.subQuery != null) {
            this.subQuery.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.singletonList(this.subQuery);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subQuery == null ? 0 : this.subQuery.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLQueryExpr other = (SQLQueryExpr)obj;
        return !(this.subQuery == null ? other.subQuery != null : !this.subQuery.equals(other.subQuery));
    }

    @Override
    public SQLQueryExpr clone() {
        SQLQueryExpr x = new SQLQueryExpr();
        if (this.subQuery != null) {
            x.setSubQuery(this.subQuery.clone());
        }
        x.parenthesized = this.parenthesized;
        return x;
    }

    @Override
    public SQLDataType computeDataType() {
        if (this.subQuery == null) {
            return null;
        }
        SQLSelectQueryBlock queryBlock = this.subQuery.getFirstQueryBlock();
        if (queryBlock == null) {
            return null;
        }
        List<SQLSelectItem> selectList = queryBlock.getSelectList();
        if (selectList.size() == 1) {
            return selectList.get(0).computeDataType();
        }
        return null;
    }
}

