/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.multimodalconversation;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiModalConversationParam
extends HalfDuplexServiceParam {
    private List<Object> messages;
    private Integer maxLength;
    private Double topP;
    private Integer topK;
    private Boolean enableSearch;
    private Integer seed;

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("model", this.getModel());
        requestObject.add("input", (JsonElement)this.getInput());
        Map<String, Object> params = this.getParameters();
        if (params != null && !params.isEmpty()) {
            requestObject.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(params));
        }
        return requestObject;
    }

    public JsonObject getInput() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("messages", (JsonElement)JsonUtils.toJsonArray(this.messages));
        return jsonObject;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.maxLength != null) {
            params.put("max_length", this.maxLength);
        }
        if (this.topP != null) {
            params.put("top_p", this.topP);
        }
        if (this.topK != null) {
            params.put("top_k", this.topK);
        }
        params.put("enable_search", this.enableSearch);
        if (this.seed != null) {
            params.put("seed", this.seed);
        }
        params.putAll(this.parameters);
        return params;
    }

    @Override
    public ByteBuffer getBinaryData() {
        return null;
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.messages == null || this.messages.isEmpty()) {
            throw new InputRequiredException("Message must not null or empty!");
        }
    }

    private static Boolean $default$enableSearch() {
        return false;
    }

    protected MultiModalConversationParam(MultiModalConversationParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        List<Object> messages;
        switch (((MultiModalConversationParamBuilder)b).messages == null ? 0 : ((MultiModalConversationParamBuilder)b).messages.size()) {
            case 0: {
                messages = Collections.emptyList();
                break;
            }
            case 1: {
                messages = Collections.singletonList(((MultiModalConversationParamBuilder)b).messages.get(0));
                break;
            }
            default: {
                messages = Collections.unmodifiableList(new ArrayList(((MultiModalConversationParamBuilder)b).messages));
            }
        }
        this.messages = messages;
        this.maxLength = ((MultiModalConversationParamBuilder)b).maxLength;
        this.topP = ((MultiModalConversationParamBuilder)b).topP;
        this.topK = ((MultiModalConversationParamBuilder)b).topK;
        this.enableSearch = ((MultiModalConversationParamBuilder)b).enableSearch$set ? ((MultiModalConversationParamBuilder)b).enableSearch$value : MultiModalConversationParam.$default$enableSearch();
        this.seed = ((MultiModalConversationParamBuilder)b).seed;
    }

    public static MultiModalConversationParamBuilder<?, ?> builder() {
        return new MultiModalConversationParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiModalConversationParam)) {
            return false;
        }
        MultiModalConversationParam other = (MultiModalConversationParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        Boolean this$enableSearch = this.getEnableSearch();
        Boolean other$enableSearch = other.getEnableSearch();
        if (this$enableSearch == null ? other$enableSearch != null : !((Object)this$enableSearch).equals(other$enableSearch)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        List<Object> this$messages = this.getMessages();
        List<Object> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultiModalConversationParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        Boolean $enableSearch = this.getEnableSearch();
        result = result * 59 + ($enableSearch == null ? 43 : ((Object)$enableSearch).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        List<Object> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    public List<Object> getMessages() {
        return this.messages;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Boolean getEnableSearch() {
        return this.enableSearch;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setMessages(List<Object> messages) {
        this.messages = messages;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public void setEnableSearch(Boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    @Override
    public String toString() {
        return "MultiModalConversationParam(messages=" + this.getMessages() + ", maxLength=" + this.getMaxLength() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ", enableSearch=" + this.getEnableSearch() + ", seed=" + this.getSeed() + ")";
    }

    private static final class MultiModalConversationParamBuilderImpl
    extends MultiModalConversationParamBuilder<MultiModalConversationParam, MultiModalConversationParamBuilderImpl> {
        private MultiModalConversationParamBuilderImpl() {
        }

        @Override
        protected MultiModalConversationParamBuilderImpl self() {
            return this;
        }

        @Override
        public MultiModalConversationParam build() {
            return new MultiModalConversationParam(this);
        }
    }

    public static abstract class MultiModalConversationParamBuilder<C extends MultiModalConversationParam, B extends MultiModalConversationParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private ArrayList<Object> messages;
        private Integer maxLength;
        private Double topP;
        private Integer topK;
        private boolean enableSearch$set;
        private Boolean enableSearch$value;
        private Integer seed;

        public B message(Object message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return (B)this.self();
        }

        public B messages(Collection<? extends Object> messages) {
            if (messages == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return (B)this.self();
        }

        public B clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return (B)this.self();
        }

        public B maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return (B)this.self();
        }

        public B topP(Double topP) {
            this.topP = topP;
            return (B)this.self();
        }

        public B topK(Integer topK) {
            this.topK = topK;
            return (B)this.self();
        }

        public B enableSearch(Boolean enableSearch) {
            this.enableSearch$value = enableSearch;
            this.enableSearch$set = true;
            return (B)this.self();
        }

        public B seed(Integer seed) {
            this.seed = seed;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "MultiModalConversationParam.MultiModalConversationParamBuilder(super=" + super.toString() + ", messages=" + this.messages + ", maxLength=" + this.maxLength + ", topP=" + this.topP + ", topK=" + this.topK + ", enableSearch$value=" + this.enableSearch$value + ", seed=" + this.seed + ")";
        }
    }
}

