/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol;

import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.DashScopeHeaders;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.HttpRequest;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.ServiceOption;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.protocol.WebSocketEventType;
import com.alibaba.dashscope.utils.Constants;
import com.alibaba.dashscope.utils.EncryptionConfig;
import com.alibaba.dashscope.utils.EncryptionUtils;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HalfDuplexRequest {
    private static final Logger log = LoggerFactory.getLogger(HalfDuplexRequest.class);
    HalfDuplexParamBase param;
    ServiceOption serviceOption;
    EncryptionConfig encryptionConfig;

    public HalfDuplexRequest(HalfDuplexParamBase param, ServiceOption option) {
        this.param = param;
        this.serviceOption = option;
        this.encryptionConfig = null;
    }

    public boolean getIsFlatten() {
        return this.serviceOption.getIsFlatten();
    }

    public String getApiKey() {
        return this.param.getApiKey();
    }

    public StreamingMode getStreamingMode() {
        return this.serviceOption.getStreamingMode();
    }

    public OutputMode getOutputMode() {
        return this.serviceOption.getOutputMode();
    }

    public String getBaseWebSocketUrl() {
        return this.serviceOption.getBaseWebSocketUrl();
    }

    public String getHttpUrl() {
        String baseUrl = Constants.baseHttpApiUrl;
        if (this.serviceOption.getBaseHttpUrl() != null) {
            baseUrl = this.serviceOption.getBaseHttpUrl();
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl + this.serviceOption.httpUrl();
    }

    public boolean isSecurityCheck() {
        return this.param.isSecurityCheck();
    }

    public HttpMethod getHttpMethod() {
        return this.serviceOption.getHttpMethod();
    }

    public Boolean isEncryptRequest() {
        return this.param.getEnableEncrypt();
    }

    public EncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig;
    }

    private String getEncryptionKeyHeader(EncryptionConfig encryptionConfig) throws ApiException {
        byte[] cipherBytes = encryptionConfig.getAESEncryptKey().getEncoded();
        String base64Cipher = Base64.getEncoder().encodeToString(cipherBytes);
        return String.format("{\"public_key_id\":\"%s\",\"encrypt_key\":\"%s\",\"iv\":\"%s\"}", encryptionConfig.getPublicKeyId(), EncryptionUtils.RSAEncrypt(base64Cipher, encryptionConfig.getBase64PublicKey()), Base64.getEncoder().encodeToString(encryptionConfig.getIv()));
    }

    public HttpRequest getHttpRequest() throws NoApiKeyException, ApiException {
        Map<String, String> paramHeaders = this.param.getHeaders();
        String customUserAgent = paramHeaders != null ? paramHeaders.get("user-agent") : null;
        HashMap<String, String> filteredHeaders = paramHeaders != null ? new HashMap<String, String>(paramHeaders) : new HashMap();
        filteredHeaders.remove("user-agent");
        Map<String, String> requestHeaders = DashScopeHeaders.buildHttpHeaders(this.param.getApiKey(), this.param.isSecurityCheck(), Protocol.HTTP, this.serviceOption.getIsSSE(), this.serviceOption.getIsAsyncTask(), this.param.getWorkspace(), filteredHeaders, customUserAgent);
        if (this.getHttpMethod() == HttpMethod.GET) {
            return ((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)HttpRequest.builder().url(this.getHttpUrl())).httpMethod(this.getHttpMethod())).headers(requestHeaders)).parameters(this.param.getParameters())).httpMethod(this.getHttpMethod())).build();
        }
        if (this.getHttpMethod() == HttpMethod.POST || this.getHttpMethod() == HttpMethod.DELETE) {
            JsonObject body = this.param.getHttpBody();
            if (this.isEncryptRequest().booleanValue() && body != null) {
                this.encryptionConfig = EncryptionUtils.generateEncryptionConfig(this.param.getApiKey());
                requestHeaders.put("X-DashScope-EncryptionKey", this.getEncryptionKeyHeader(this.encryptionConfig));
                JsonObject input = body.get("input").getAsJsonObject();
                String chiperInput = EncryptionUtils.AESEncrypt(JsonUtils.toJson(input), this.encryptionConfig.getAESEncryptKey(), this.encryptionConfig.getIv());
                body.addProperty("input", chiperInput);
            }
            return ((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)((HttpRequest.HttpRequestBuilder)HttpRequest.builder().url(this.getHttpUrl())).headers(requestHeaders)).body(body == null ? null : JsonUtils.toJson(body))).httpMethod(this.getHttpMethod())).build();
        }
        return ((HttpRequest.HttpRequestBuilder)HttpRequest.builder().httpMethod(this.getHttpMethod())).build();
    }

    public JsonObject getWebSocketPayload() {
        JsonObject request = new JsonObject();
        request.addProperty("model", this.param.getModel());
        request.addProperty("task_group", this.serviceOption.getTaskGroup());
        request.addProperty("task", this.serviceOption.getTask());
        request.addProperty("function", this.serviceOption.getFunction());
        if (this.param.getBinaryData() == null) {
            request.add("input", (JsonElement)((JsonObject)this.param.getInput()));
        }
        if (this.param.getParameters() != null) {
            request.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.param.getParameters()));
        }
        if (this.param.getResources() != null) {
            request.add("resources", (JsonElement)this.param.getResources());
        }
        return request;
    }

    public JsonObject getWebSocketPayload(Object data) {
        JsonObject request = new JsonObject();
        request.addProperty("model", this.param.getModel());
        request.addProperty("task_group", this.serviceOption.getTaskGroup());
        request.addProperty("task", this.serviceOption.getTask());
        request.addProperty("function", this.serviceOption.getFunction());
        if (data instanceof String) {
            request.add("input", (JsonElement)((JsonObject)this.param.getInput()));
        } else {
            request.add("input", (JsonElement)new JsonObject());
        }
        if (this.param.getParameters() != null) {
            request.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.param.getParameters()));
        }
        if (this.param.getResources() != null) {
            request.add("resources", (JsonElement)((JsonObject)this.param.getResources()));
        }
        return request;
    }

    public JsonObject getStartTaskMessage() {
        JsonObject header = new JsonObject();
        header.addProperty("action", WebSocketEventType.RUN_TASK.getValue());
        if (this.param.getParameters() != null && this.param.getParameters().containsKey("pre_task_id")) {
            header.addProperty("task_id", (String)this.param.getParameters().get("pre_task_id"));
        } else {
            header.addProperty("task_id", UUID.randomUUID().toString());
        }
        header.addProperty("streaming", this.serviceOption.getStreamingMode().getValue());
        JsonObject wsMessage = new JsonObject();
        wsMessage.add("header", (JsonElement)header);
        wsMessage.add("payload", (JsonElement)this.getWebSocketPayload());
        return wsMessage;
    }

    public ByteBuffer getWebsocketBinaryData() {
        return this.param.getBinaryData();
    }

    public Map<String, String> getHeaders() {
        return this.param.getHeaders();
    }

    public String getWorkspace() {
        return this.param.getWorkspace();
    }
}

