/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.common;

import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.threads.AssistantStreamEvents;
import com.alibaba.dashscope.threads.AssistantThread;
import com.alibaba.dashscope.threads.messages.ThreadMessage;
import com.alibaba.dashscope.threads.messages.ThreadMessageDelta;
import com.alibaba.dashscope.threads.runs.AssistantStreamMessage;
import com.alibaba.dashscope.threads.runs.Run;
import com.alibaba.dashscope.threads.runs.RunStep;
import com.alibaba.dashscope.threads.runs.RunStepDelta;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;

public abstract class FlattenResultBase {
    @SerializedName(value="request_id")
    private String requestId;

    protected FlattenResultBase() {
    }

    public static <T extends FlattenResultBase> T fromDashScopeResult(DashScopeResult dashScopeResult, Type type) {
        FlattenResultBase obj = (FlattenResultBase)JsonUtils.fromJson((JsonElement)((JsonObject)dashScopeResult.getOutput()), type);
        return (T)obj;
    }

    public static AssistantStreamMessage fromDashScopeResult(DashScopeResult dashScopeResult, Type type, boolean stream) {
        String event = dashScopeResult.getEvent();
        AssistantStreamMessage asm = new AssistantStreamMessage();
        asm.setEvent(AssistantStreamEvents.fromValue(event));
        if (stream) {
            switch (AssistantStreamEvents.fromValue(dashScopeResult.getEvent())) {
                case THREAD_CREATED: {
                    AssistantThread thread = (AssistantThread)FlattenResultBase.fromDashScopeResult(dashScopeResult, AssistantThread.class);
                    asm.setData(thread);
                    return asm;
                }
                case THREAD_RUN_CREATED: 
                case THREAD_RUN_QUEUED: 
                case THREAD_RUN_IN_PROGRESS: 
                case THREAD_RUN_REQUIRES_ACTION: 
                case THREAD_RUN_COMPLETED: 
                case THREAD_RUN_FAILED: 
                case THREAD_RUN_CANCELLING: 
                case THREAD_RUN_CANCELED: 
                case THREAD_RUN_EXPIRED: {
                    Run run = (Run)FlattenResultBase.fromDashScopeResult(dashScopeResult, Run.class);
                    asm.setData(run);
                    return asm;
                }
                case THREAD_RUN_STEP_CREATED: 
                case THREAD_RUN_STEP_IN_PROGRESS: 
                case THREAD_RUN_STEP_COMPLETED: 
                case THREAD_RUN_STEP_FAILED: 
                case THREAD_RUN_STEP_CANCELLED: 
                case THREAD_RUN_STEP_EXPIRED: {
                    RunStep runStep = (RunStep)FlattenResultBase.fromDashScopeResult(dashScopeResult, RunStep.class);
                    asm.setData(runStep);
                    return asm;
                }
                case THREAD_RUN_STEP_DELTA: {
                    asm.setData(FlattenResultBase.fromDashScopeResult(dashScopeResult, RunStepDelta.class));
                    return asm;
                }
                case THREAD_MESSAGE_CREATED: 
                case THREAD_MESSAGE_COMPLETED: 
                case THREAD_MESSAGE_INCOMPLETE: {
                    ThreadMessage threadMessage = (ThreadMessage)FlattenResultBase.fromDashScopeResult(dashScopeResult, ThreadMessage.class);
                    asm.setData(threadMessage);
                    return asm;
                }
                case THREAD_MESSAGE_DELTA: {
                    asm.setData(ThreadMessageDelta.fromDashScopeResult(dashScopeResult, ThreadMessageDelta.class));
                    return asm;
                }
            }
            asm.setData(JsonUtils.toJson(dashScopeResult.getOutput()));
            return asm;
        }
        return (AssistantStreamMessage)FlattenResultBase.fromDashScopeResult(dashScopeResult, type);
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlattenResultBase)) {
            return false;
        }
        FlattenResultBase other = (FlattenResultBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlattenResultBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }

    public String toString() {
        return "FlattenResultBase(requestId=" + this.getRequestId() + ")";
    }
}

