/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.generation;

import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ClientOptions;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import io.reactivex.Flowable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Generation {
    private static final Logger log = LoggerFactory.getLogger(Generation.class);
    private final SynchronizeHalfDuplexApi<HalfDuplexServiceParam> syncApi;
    private final ApiServiceOption serviceOption = this.defaultApiServiceOption();

    private ApiServiceOption defaultApiServiceOption() {
        return ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.OUT)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AIGC.getValue())).task(Task.TEXT_GENERATION.getValue())).function(Function.GENERATION.getValue())).build();
    }

    public Generation() {
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public Generation(String protocol) {
        this.serviceOption.setProtocol(Protocol.of(protocol));
        this.syncApi = new SynchronizeHalfDuplexApi((ClientOptions)((ClientOptions.ClientOptionsBuilder)ClientOptions.builder().protocol(protocol)).build(), this.serviceOption);
    }

    public Generation(String protocol, String baseUrl) {
        this.serviceOption.setProtocol(Protocol.of(protocol));
        if (protocol.equals(Protocol.HTTP.getValue())) {
            this.serviceOption.setBaseHttpUrl(baseUrl);
        } else {
            this.serviceOption.setBaseWebSocketUrl(baseUrl);
        }
        this.syncApi = new SynchronizeHalfDuplexApi((ClientOptions)((ClientOptions.ClientOptionsBuilder)ClientOptions.builder().protocol(protocol)).build(), this.serviceOption);
    }

    public GenerationResult call(HalfDuplexServiceParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        return GenerationResult.fromDashScopeResult(this.syncApi.call(param));
    }

    public void call(HalfDuplexServiceParam param, final ResultCallback<GenerationResult> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        this.syncApi.call(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult message) {
                callback.onEvent(GenerationResult.fromDashScopeResult(message));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public Flowable<GenerationResult> streamCall(HalfDuplexServiceParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        return this.syncApi.streamCall(param).map(item -> GenerationResult.fromDashScopeResult(item));
    }

    public void streamCall(HalfDuplexServiceParam param, final ResultCallback<GenerationResult> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        this.syncApi.streamCall(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult msg) {
                callback.onEvent(GenerationResult.fromDashScopeResult(msg));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public static class Models {
        @Deprecated
        public static final String QWEN_V1 = "qwen-v1";
        public static final String QWEN_TURBO = "qwen-turbo";
        public static final String BAILIAN_V1 = "bailian-v1";
        public static final String DOLLY_12B_V2 = "dolly-12b-v2";
        @Deprecated
        public static final String QWEN_PLUS_V1 = "qwen-plus-v1";
        public static final String QWEN_PLUS = "qwen-plus";
        public static final String QWEN_MAX = "qwen-max";
    }
}

