/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.controller;

import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.slots.block.flow.TrafficShapingController;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public class ThrottlingController
implements TrafficShapingController {
    private static final long MS_TO_NS_OFFSET = TimeUnit.MILLISECONDS.toNanos(1L);
    private final int maxQueueingTimeMs;
    private final int statDurationMs;
    private final double count;
    private final boolean useNanoSeconds;
    private final AtomicLong latestPassedTime = new AtomicLong(-1L);

    public ThrottlingController(int queueingTimeoutMs, double maxCountPerStat) {
        this(queueingTimeoutMs, maxCountPerStat, 1000);
    }

    public ThrottlingController(int queueingTimeoutMs, double maxCountPerStat, int statDurationMs) {
        AssertUtil.assertTrue(statDurationMs > 0, "statDurationMs should be positive");
        AssertUtil.assertTrue(maxCountPerStat >= 0.0, "maxCountPerStat should be >= 0");
        AssertUtil.assertTrue(queueingTimeoutMs >= 0, "queueingTimeoutMs should be >= 0");
        this.maxQueueingTimeMs = queueingTimeoutMs;
        this.count = maxCountPerStat;
        this.statDurationMs = statDurationMs;
        this.useNanoSeconds = maxCountPerStat > 0.0 ? (long)statDurationMs % Math.round(maxCountPerStat) != 0L || maxCountPerStat / (double)statDurationMs > 1.0 : false;
    }

    @Override
    public boolean canPass(Node node, int acquireCount) {
        return this.canPass(node, acquireCount, false);
    }

    private boolean checkPassUsingNanoSeconds(int acquireCount, double maxCountPerStat) {
        long maxQueueingTimeNs = (long)this.maxQueueingTimeMs * MS_TO_NS_OFFSET;
        long currentTime = System.nanoTime();
        long costTimeNs = Math.round(1.0 * (double)MS_TO_NS_OFFSET * (double)this.statDurationMs * (double)acquireCount / maxCountPerStat);
        long expectedTime = costTimeNs + this.latestPassedTime.get();
        if (expectedTime <= currentTime) {
            this.latestPassedTime.set(currentTime);
            return true;
        }
        long curNanos = System.nanoTime();
        long waitTime = costTimeNs + this.latestPassedTime.get() - curNanos;
        if (waitTime > maxQueueingTimeNs) {
            return false;
        }
        long oldTime = this.latestPassedTime.addAndGet(costTimeNs);
        waitTime = oldTime - curNanos;
        if (waitTime > maxQueueingTimeNs) {
            this.latestPassedTime.addAndGet(-costTimeNs);
            return false;
        }
        if (waitTime > 0L) {
            this.sleepNanos(waitTime);
        }
        return true;
    }

    private boolean checkPassUsingCachedMs(int acquireCount, double maxCountPerStat) {
        long currentTime = TimeUtil.currentTimeMillis();
        long costTime = Math.round(1.0 * (double)this.statDurationMs * (double)acquireCount / maxCountPerStat);
        long expectedTime = costTime + this.latestPassedTime.get();
        if (expectedTime <= currentTime) {
            this.latestPassedTime.set(currentTime);
            return true;
        }
        long waitTime = costTime + this.latestPassedTime.get() - TimeUtil.currentTimeMillis();
        if (waitTime > (long)this.maxQueueingTimeMs) {
            return false;
        }
        long oldTime = this.latestPassedTime.addAndGet(costTime);
        waitTime = oldTime - TimeUtil.currentTimeMillis();
        if (waitTime > (long)this.maxQueueingTimeMs) {
            this.latestPassedTime.addAndGet(-costTime);
            return false;
        }
        if (waitTime > 0L) {
            this.sleepMs(waitTime);
        }
        return true;
    }

    @Override
    public boolean canPass(Node node, int acquireCount, boolean prioritized) {
        if (acquireCount <= 0) {
            return true;
        }
        if (this.count <= 0.0) {
            return false;
        }
        if (this.useNanoSeconds) {
            return this.checkPassUsingNanoSeconds(acquireCount, this.count);
        }
        return this.checkPassUsingCachedMs(acquireCount, this.count);
    }

    private void sleepMs(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sleepNanos(long ns) {
        LockSupport.parkNanos(ns);
    }
}

