/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.endpoint;

import com.alibaba.cloud.sentinel.SentinelProperties;
import com.alibaba.cloud.sentinel.endpoint.SentinelEndpoint;
import com.alibaba.cloud.sentinel.endpoint.SentinelHealthIndicator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={Endpoint.class})
@EnableConfigurationProperties(value={SentinelProperties.class})
public class SentinelEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint
    public SentinelEndpoint sentinelEndPoint(SentinelProperties sentinelProperties) {
        return new SentinelEndpoint(sentinelProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledHealthIndicator(value="sentinel")
    public SentinelHealthIndicator sentinelHealthIndicator(DefaultListableBeanFactory beanFactory, SentinelProperties sentinelProperties) {
        return new SentinelHealthIndicator(beanFactory, sentinelProperties);
    }
}

