/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.service;

import com.alibaba.cloud.ai.agent.studio.dto.ListThreadsResponse;
import com.alibaba.cloud.ai.agent.studio.dto.Thread;
import com.alibaba.cloud.ai.agent.studio.service.ThreadService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ThreadServiceImpl
implements ThreadService {
    private static final Logger log = LoggerFactory.getLogger(ThreadServiceImpl.class);
    private final Map<String, Thread> threads = new ConcurrentHashMap<String, Thread>();
    private final Map<String, Map<String, Object>> thradStates = new ConcurrentHashMap<String, Map<String, Object>>();

    @Override
    public Mono<Optional<Thread>> getThread(String appName, String userId, String threadId, Optional<Map<String, Object>> state) {
        return Mono.fromCallable(() -> {
            String key = this.buildKey(appName, userId, threadId);
            Thread thread = this.threads.get(key);
            return Optional.ofNullable(thread);
        });
    }

    @Override
    public Mono<ListThreadsResponse> listThreads(String appName, String userId) {
        return Mono.fromCallable(() -> {
            String prefix = this.buildKeyPrefix(appName, userId);
            List<Thread> userThreads = this.threads.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).map(Map.Entry::getValue).collect(Collectors.toList());
            log.debug("Found {} threads for app={}, user={}", new Object[]{userThreads.size(), appName, userId});
            return ListThreadsResponse.of(userThreads);
        });
    }

    @Override
    public Mono<Thread> createThread(String appName, String userId, Map<String, Object> initialState, String threadId) {
        return Mono.fromCallable(() -> {
            String finalThreadId = threadId == null || threadId.trim().isEmpty() ? this.generateThreadId() : threadId;
            String key = this.buildKey(appName, userId, finalThreadId);
            if (this.threads.containsKey(key)) {
                log.warn("Attempted to create duplicate thread: {}", (Object)finalThreadId);
                throw new IllegalStateException("Thread already exists: " + finalThreadId);
            }
            Thread newThread = Thread.builder(finalThreadId).appName(appName).userId(userId).build();
            this.threads.put(key, newThread);
            if (initialState != null && !initialState.isEmpty()) {
                this.thradStates.put(key, new ConcurrentHashMap(initialState));
            }
            log.info("Created thread: {} for app={}, user={}", new Object[]{finalThreadId, appName, userId});
            return newThread;
        });
    }

    @Override
    public Mono<Void> deleteThread(String appName, String userId, String threadId) {
        return Mono.fromRunnable(() -> {
            String key = this.buildKey(appName, userId, threadId);
            Thread removed = this.threads.remove(key);
            this.thradStates.remove(key);
            if (removed != null) {
                log.info("Deleted thread: {} for app={}, user={}", new Object[]{threadId, appName, userId});
            } else {
                log.warn("Attempted to delete non-existent thread: {}", (Object)threadId);
            }
        });
    }

    public Map<String, Object> getThreadState(String appName, String userId, String threadId) {
        String key = this.buildKey(appName, userId, threadId);
        return this.thradStates.getOrDefault(key, new ConcurrentHashMap());
    }

    public void updateThreadState(String appName, String userId, String threadId, Map<String, Object> state) {
        String key = this.buildKey(appName, userId, threadId);
        if (this.threads.containsKey(key)) {
            this.thradStates.put(key, new ConcurrentHashMap<String, Object>(state));
            Thread thread = this.threads.get(key);
            log.debug("Updated state for thread: {}", (Object)threadId);
        }
    }

    private String buildKey(String appName, String userId, String threadId) {
        return String.format("%s:%s:%s", appName, userId, threadId);
    }

    private String buildKeyPrefix(String appName, String userId) {
        return String.format("%s:%s:", appName, userId);
    }

    private String generateThreadId() {
        return UUID.randomUUID().toString();
    }
}

