/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.observation.model;

import com.alibaba.cloud.ai.observation.model.ObservationMetadataAwareOptions;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import java.util.Collections;
import java.util.Map;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.lang.NonNull;

public class PromptMetadataAwareChatModelObservationConvention
extends DefaultChatModelObservationConvention {
    @NonNull
    public KeyValues getLowCardinalityKeyValues(@NonNull ChatModelObservationContext context) {
        return super.getLowCardinalityKeyValues(context);
    }

    @NonNull
    public KeyValues getHighCardinalityKeyValues(@NonNull ChatModelObservationContext context) {
        KeyValues keyValues = super.getHighCardinalityKeyValues(context);
        keyValues = this.promptKey(keyValues, context);
        keyValues = this.promptVersion(keyValues, context);
        keyValues = this.promptTemplate(keyValues, context);
        keyValues = this.promptVariables(keyValues, context);
        keyValues = this.agentName(keyValues, context);
        keyValues = this.agentIp(keyValues, context);
        keyValues = this.studioSource(keyValues, context);
        return keyValues;
    }

    protected KeyValues promptKey(KeyValues keyValues, ChatModelObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("promptKey")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.prompt.key", (String)metadata.get("promptKey"))});
        }
        return keyValues;
    }

    protected KeyValues promptVersion(KeyValues keyValues, ChatModelObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("promptVersion")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.prompt.version", (String)metadata.get("promptVersion"))});
        }
        return keyValues;
    }

    protected KeyValues promptTemplate(KeyValues keyValues, ChatModelObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("promptTemplate")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.prompt.template", (String)metadata.get("promptTemplate"))});
        }
        return keyValues;
    }

    protected KeyValues promptVariables(KeyValues keyValues, ChatModelObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("promptVariables")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.prompt.variable", (String)metadata.get("promptVariables"))});
        }
        return keyValues;
    }

    protected KeyValues agentName(KeyValues keyValues, ChatModelObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("agentName")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.agent.name", (String)metadata.get("agentName"))});
        }
        return keyValues;
    }

    protected KeyValues agentIp(KeyValues keyValues, ChatModelObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("agentIp")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.agent.ip", (String)metadata.get("agentIp"))});
        }
        return keyValues;
    }

    protected KeyValues studioSource(KeyValues keyValues, ChatModelObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("studioSource")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.studio.source", (String)metadata.get("studioSource"))});
        }
        return keyValues;
    }

    private Map<String, String> getMetadata(ChatModelObservationContext context) {
        Map<String, String> metadata;
        ChatOptions options = ((Prompt)context.getRequest()).getOptions();
        if (options instanceof ObservationMetadataAwareOptions && (metadata = ((ObservationMetadataAwareOptions)options).getObservationMetadata()) != null) {
            return metadata;
        }
        return Collections.emptyMap();
    }
}

