/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.document;

import com.alibaba.cloud.ai.model.RerankResultMetadata;
import java.util.Objects;
import org.springframework.ai.document.Document;
import org.springframework.ai.model.ModelResult;
import org.springframework.ai.model.ResultMetadata;

public class DocumentWithScore
implements ModelResult<Document> {
    private Double score;
    private Document document;
    private RerankResultMetadata metadata;

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setMetadata(RerankResultMetadata metadata) {
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Document getOutput() {
        return this.document;
    }

    public ResultMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentWithScore that = (DocumentWithScore)o;
        return Objects.equals(this.score, that.score) && Objects.equals(this.document, that.document);
    }

    public int hashCode() {
        return Objects.hash(this.score, this.document);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DocumentWithScore{");
        sb.append("score=").append(this.score);
        sb.append(", document=").append(this.document);
        sb.append('}');
        return sb.toString();
    }

    public static final class Builder {
        private final DocumentWithScore documentWithScore = new DocumentWithScore();

        private Builder() {
        }

        public Builder withScore(Double score) {
            this.documentWithScore.setScore(score);
            return this;
        }

        public Builder withDocument(Document document) {
            this.documentWithScore.setDocument(document);
            return this;
        }

        public Builder withMetadata(RerankResultMetadata metadata) {
            this.documentWithScore.setMetadata(metadata);
            return this;
        }

        public DocumentWithScore build() {
            return this.documentWithScore;
        }
    }
}

