/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.common.DashScopeException;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeDocumentRetrieverOptions;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeStoreOptions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.ai.document.Document;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DashScopeCloudStore
implements VectorStore {
    private final DashScopeStoreOptions options;
    private final DashScopeApi dashScopeApi;

    public DashScopeCloudStore(DashScopeApi dashScopeApi, DashScopeStoreOptions options) {
        Assert.notNull((Object)options, (String)"DashScopeStoreOptions must not be null");
        Assert.notNull((Object)options.getIndexName(), (String)"IndexName must not be null");
        this.options = options;
        this.dashScopeApi = dashScopeApi;
    }

    public String getName() {
        return super.getName();
    }

    public void add(List<Document> documents) {
        if (CollectionUtils.isEmpty(documents)) {
            throw new DashScopeException("documents must not be null");
        }
        List documentIdList = documents.stream().filter(e -> e.getId() != null).map(Document::getId).collect(Collectors.toList());
        if (documentIdList == null || documentIdList.isEmpty()) {
            throw new DashScopeException("document's id must not be null");
        }
        this.dashScopeApi.upsertPipeline(documents, this.options);
    }

    public void delete(List<String> idList) {
        String pipelineId = this.dashScopeApi.getPipelineIdByName(this.options.getIndexName());
        if (pipelineId == null) {
            throw new DashScopeException("Index:" + this.options.getIndexName() + " NotExist");
        }
        this.dashScopeApi.deletePipelineDocument(pipelineId, idList);
    }

    public void delete(Filter.Expression filterExpression) {
    }

    public List<Document> similaritySearch(String query) {
        return this.similaritySearch(SearchRequest.builder().query(query).build());
    }

    public <T> Optional<T> getNativeClient() {
        return super.getNativeClient();
    }

    public List<Document> similaritySearch(SearchRequest request) {
        String pipelineId = this.dashScopeApi.getPipelineIdByName(this.options.getIndexName());
        if (pipelineId == null) {
            throw new DashScopeException("Index:" + this.options.getIndexName() + " NotExist");
        }
        DashScopeDocumentRetrieverOptions searchOption = this.options.getRetrieverOptions();
        if (searchOption == null) {
            searchOption = new DashScopeDocumentRetrieverOptions();
        }
        searchOption.setRerankTopN(request.getTopK());
        return this.dashScopeApi.retriever(pipelineId, request.getQuery(), searchOption);
    }
}

