/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.image.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import java.util.Collection;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.observation.ImageModelObservationContext;
import org.springframework.util.CollectionUtils;

public class DashScopeImagePromptContentObservationHandler
implements ObservationHandler<ImageModelObservationContext> {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeImagePromptContentObservationHandler.class);

    public void onStop(ImageModelObservationContext context) {
        if (!CollectionUtils.isEmpty((Collection)((ImagePrompt)context.getRequest()).getInstructions())) {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            ((ImagePrompt)context.getRequest()).getInstructions().forEach(msg -> joiner.add("\"" + msg.getText() + "\""));
            logger.info("DashScope image model Prompt : {}", (Object)joiner);
        }
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ImageModelObservationContext;
    }
}

