/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.audio;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.audio.transcription.AudioTranscriptionOptions;

public class DashScopeAudioTranscriptionOptions
implements AudioTranscriptionOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="vocabulary_id")
    private String vocabularyId;
    @JsonProperty(value="resource_id")
    private String resourceId;
    @JsonProperty(value="sample_rate")
    private Integer sampleRate;
    @JsonProperty(value="format")
    private AudioFormat format;
    @JsonProperty(value="channel_id")
    private List<Integer> channelId = List.of(Integer.valueOf(0));
    @JsonProperty(value="disfluency_removal_enabled")
    private Boolean disfluencyRemovalEnabled = false;
    @JsonProperty(value="timestamp_alignment_enabled")
    private Boolean timestampAlignmentEnabled = false;
    @JsonProperty(value="special_word_filter")
    private String specialWordFilter;
    @JsonProperty(value="language_hints")
    private List<String> languageHints = List.of("zh", "en");
    @JsonProperty(value="diarization_enabled")
    private Boolean diarizationEnabled = false;
    @JsonProperty(value="speaker_count")
    private Integer speakerCount;

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getVocabularyId() {
        return this.vocabularyId;
    }

    public void setVocabularyId(String vocabularyId) {
        this.vocabularyId = vocabularyId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public Integer getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Integer sampleRate) {
        this.sampleRate = sampleRate;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public void setFormat(AudioFormat format) {
        this.format = format;
    }

    public List<Integer> getChannelId() {
        return this.channelId;
    }

    public void setChannelId(List<Integer> channelId) {
        this.channelId = channelId;
    }

    public Boolean getDisfluencyRemovalEnabled() {
        return this.disfluencyRemovalEnabled;
    }

    public void setDisfluencyRemovalEnabled(Boolean disfluencyRemovalEnabled) {
        this.disfluencyRemovalEnabled = disfluencyRemovalEnabled;
    }

    public Boolean getTimestampAlignmentEnabled() {
        return this.timestampAlignmentEnabled;
    }

    public void setTimestampAlignmentEnabled(Boolean timestampAlignmentEnabled) {
        this.timestampAlignmentEnabled = timestampAlignmentEnabled;
    }

    public String getSpecialWordFilter() {
        return this.specialWordFilter;
    }

    public void setSpecialWordFilter(String specialWordFilter) {
        this.specialWordFilter = specialWordFilter;
    }

    public List<String> getLanguageHints() {
        return this.languageHints;
    }

    public void setLanguageHints(List<String> languageHints) {
        this.languageHints = languageHints;
    }

    public Boolean getDiarizationEnabled() {
        return this.diarizationEnabled;
    }

    public void setDiarizationEnabled(Boolean diarizationEnabled) {
        this.diarizationEnabled = diarizationEnabled;
    }

    public Integer getSpeakerCount() {
        return this.speakerCount;
    }

    public void setSpeakerCount(Integer speakerCount) {
        this.speakerCount = speakerCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum AudioFormat {
        PCM("pcm"),
        WAV("wav"),
        MP3("mp3"),
        OPUS("opus"),
        SPEEX("speex"),
        AAC("aac"),
        AMR("amr");

        public final String value;

        private AudioFormat(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private final DashScopeAudioTranscriptionOptions options = new DashScopeAudioTranscriptionOptions();

        public Builder withModel(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder withVocabularyId(String vocabularyId) {
            this.options.setVocabularyId(vocabularyId);
            return this;
        }

        public Builder withResourceId(String resourceId) {
            this.options.setResourceId(resourceId);
            return this;
        }

        public Builder withSampleRate(Integer sampleRate) {
            this.options.setSampleRate(sampleRate);
            return this;
        }

        public Builder withFormat(AudioFormat format) {
            this.options.setFormat(format);
            return this;
        }

        public Builder withChannelId(List<Integer> channelId) {
            this.options.setChannelId(channelId);
            return this;
        }

        public Builder withDisfluencyRemovalEnabled(Boolean disfluencyRemovalEnabled) {
            this.options.setDisfluencyRemovalEnabled(disfluencyRemovalEnabled);
            return this;
        }

        public Builder withTimestampAlignmentEnabled(Boolean timestampAlignmentEnabled) {
            this.options.setTimestampAlignmentEnabled(timestampAlignmentEnabled);
            return this;
        }

        public Builder withSpecialWordFilter(String specialWordFilter) {
            this.options.setSpecialWordFilter(specialWordFilter);
            return this;
        }

        public Builder withLanguageHints(List<String> languageHints) {
            this.options.setLanguageHints(languageHints);
            return this;
        }

        public Builder withDiarizationEnabled(Boolean diarizationEnabled) {
            this.options.setDiarizationEnabled(diarizationEnabled);
            return this;
        }

        public Builder withSpeakerCount(Integer speakerCount) {
            this.options.setSpeakerCount(speakerCount);
            return this;
        }

        public DashScopeAudioTranscriptionOptions build() {
            return this.options;
        }
    }
}

