/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.agent.DashScopeAgentFlowStreamMode;
import com.alibaba.cloud.ai.dashscope.api.ApiUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DashScopeAgentApi {
    private final RestClient restClient;
    private final WebClient webClient;

    public DashScopeAgentApi(String apiKey) {
        this("https://dashscope.aliyuncs.com", apiKey, RestClient.builder(), WebClient.builder(), RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public DashScopeAgentApi(String apiKey, String workSpaceId) {
        this("https://dashscope.aliyuncs.com", apiKey, workSpaceId, RestClient.builder(), WebClient.builder(), RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public DashScopeAgentApi(String baseUrl, String apiKey, String workSpaceId) {
        this(baseUrl, apiKey, workSpaceId, RestClient.builder(), WebClient.builder(), RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public DashScopeAgentApi(String baseUrl, String apiKey, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey)).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey, null, true)).build();
    }

    public DashScopeAgentApi(String baseUrl, String apiKey, String workSpaceId, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey, workSpaceId)).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey, workSpaceId, true)).build();
    }

    public ResponseEntity<DashScopeAgentResponse> call(DashScopeAgentRequest request) {
        String uri = "/api/v1/apps/" + request.appId() + "/completion";
        return ((RestClient.RequestBodySpec)this.restClient.post().uri(uri, new Object[0])).body((Object)request).retrieve().toEntity(DashScopeAgentResponse.class);
    }

    public Flux<DashScopeAgentResponse> stream(DashScopeAgentRequest request) {
        String uri = "/api/v1/apps/" + request.appId() + "/completion";
        return ((WebClient.RequestBodySpec)this.webClient.post().uri(uri, new Object[0])).body((Object)Mono.just((Object)request), DashScopeAgentResponse.class).retrieve().bodyToFlux(DashScopeAgentResponse.class).handle((data, sink) -> sink.next(data));
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DashScopeAgentRequest(@JsonProperty(value="app_id") String appId, @JsonProperty(value="input") DashScopeAgentRequestInput input, @JsonProperty(value="parameters") DashScopeAgentRequestParameters parameters) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeAgentRequestInput(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="messages") List<DashScopeAgentRequestMessage> messages, @JsonProperty(value="session_id") String sessionId, @JsonProperty(value="memory_id") String memoryId, @JsonProperty(value="image_list") List<String> images, @JsonProperty(value="biz_params") JsonNode bizParams) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record DashScopeAgentRequestMessage(@JsonProperty(value="role") String role, @JsonProperty(value="content") String content) {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeAgentRequestParameters(@JsonProperty(value="flow_stream_mode") DashScopeAgentFlowStreamMode flowStreamMode, @JsonProperty(value="has_thoughts") Boolean hasThoughts, @JsonProperty(value="incremental_output") Boolean incrementalOutput, @JsonProperty(value="rag_options") DashScopeAgentRequestRagOptions ragOptions) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record DashScopeAgentRequestRagOptions(@JsonProperty(value="pipeline_ids") List<String> pipelineIds, @JsonProperty(value="file_ids") List<String> fileIds, @JsonProperty(value="metadata_filter") JsonNode metadataFilter, @JsonProperty(value="tags") List<String> tags, @JsonProperty(value="structured_filter") JsonNode structuredFilter, @JsonProperty(value="session_file_ids") List<String> sessionFileIds) {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DashScopeAgentResponse(@JsonProperty(value="status_code") Integer statusCode, @JsonProperty(value="request_id") String requestId, @JsonProperty(value="code") String code, @JsonProperty(value="message") String message, @JsonProperty(value="output") DashScopeAgentResponseOutput output, @JsonProperty(value="usage") DashScopeAgentResponseUsage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeAgentResponseOutput(@JsonProperty(value="text") String text, @JsonProperty(value="finish_reason") String finishReason, @JsonProperty(value="session_id") String sessionId, @JsonProperty(value="thoughts") List<DashScopeAgentResponseOutputThoughts> thoughts, @JsonProperty(value="doc_references") List<DashScopeAgentResponseOutputDocReference> docReferences) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record DashScopeAgentResponseOutputDocReference(@JsonProperty(value="index_id") String indexId, @JsonProperty(value="title") String title, @JsonProperty(value="doc_id") String docId, @JsonProperty(value="doc_name") String docName, @JsonProperty(value="text") String text, @JsonProperty(value="images") List<String> images, @JsonProperty(value="page_number") List<Integer> pageNumber) {
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record DashScopeAgentResponseOutputThoughts(@JsonProperty(value="thought") String thought, @JsonProperty(value="action_type") String actionType, @JsonProperty(value="action_name") String actionName, @JsonProperty(value="action") String action, @JsonProperty(value="action_input_stream") String actionInputStream, @JsonProperty(value="action_input") String actionInput, @JsonProperty(value="response") String response, @JsonProperty(value="observation") String observation, @JsonProperty(value="reasoning_content") String reasoningContent) {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeAgentResponseUsage(@JsonProperty(value="models") List<DashScopeAgentResponseUsageModels> models) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record DashScopeAgentResponseUsageModels(@JsonProperty(value="model_id") String modelId, @JsonProperty(value="input_tokens") Integer inputTokens, @JsonProperty(value="output_tokens") Integer outputTokens) {
            }
        }
    }
}

