/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.hook.pii;

import com.alibaba.cloud.ai.graph.agent.hook.pii.PIIDetector;
import com.alibaba.cloud.ai.graph.agent.hook.pii.PIIMatch;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PIIDetectors {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("\\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Z|a-z]{2,}\\b");
    private static final Pattern CREDIT_CARD_PATTERN = Pattern.compile("\\b\\d{4}[\\s-]?\\d{4}[\\s-]?\\d{4}[\\s-]?\\d{4}\\b");
    private static final Pattern IPV4_PATTERN = Pattern.compile("\\b(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\b");
    private static final Pattern MAC_ADDRESS_PATTERN = Pattern.compile("\\b([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})\\b");
    private static final Pattern URL_PATTERN = Pattern.compile("\\bhttps?://[\\w\\-]+(\\.[\\w\\-]+)+[/#?]?.*?\\b");

    public static PIIDetector emailDetector() {
        return content -> {
            ArrayList<PIIMatch> matches = new ArrayList<PIIMatch>();
            Matcher matcher = EMAIL_PATTERN.matcher(content);
            while (matcher.find()) {
                matches.add(new PIIMatch("email", matcher.group(), matcher.start(), matcher.end()));
            }
            return matches;
        };
    }

    public static PIIDetector creditCardDetector() {
        return content -> {
            ArrayList<PIIMatch> matches = new ArrayList<PIIMatch>();
            Matcher matcher = CREDIT_CARD_PATTERN.matcher(content);
            while (matcher.find()) {
                String cardNumber = matcher.group();
                if (!PIIDetectors.passesLuhn(cardNumber)) continue;
                matches.add(new PIIMatch("credit_card", cardNumber, matcher.start(), matcher.end()));
            }
            return matches;
        };
    }

    public static PIIDetector ipDetector() {
        return content -> {
            ArrayList<PIIMatch> matches = new ArrayList<PIIMatch>();
            Matcher matcher = IPV4_PATTERN.matcher(content);
            while (matcher.find()) {
                String ip = matcher.group();
                try {
                    InetAddress.getByName(ip);
                    matches.add(new PIIMatch("ip", ip, matcher.start(), matcher.end()));
                }
                catch (Exception exception) {}
            }
            return matches;
        };
    }

    public static PIIDetector macAddressDetector() {
        return content -> {
            ArrayList<PIIMatch> matches = new ArrayList<PIIMatch>();
            Matcher matcher = MAC_ADDRESS_PATTERN.matcher(content);
            while (matcher.find()) {
                matches.add(new PIIMatch("mac_address", matcher.group(), matcher.start(), matcher.end()));
            }
            return matches;
        };
    }

    public static PIIDetector urlDetector() {
        return content -> {
            ArrayList<PIIMatch> matches = new ArrayList<PIIMatch>();
            Matcher matcher = URL_PATTERN.matcher(content);
            while (matcher.find()) {
                matches.add(new PIIMatch("url", matcher.group(), matcher.start(), matcher.end()));
            }
            return matches;
        };
    }

    public static PIIDetector regexDetector(String type, String pattern) {
        Pattern compiledPattern = Pattern.compile(pattern);
        return content -> {
            ArrayList<PIIMatch> matches = new ArrayList<PIIMatch>();
            Matcher matcher = compiledPattern.matcher(content);
            while (matcher.find()) {
                matches.add(new PIIMatch(type, matcher.group(), matcher.start(), matcher.end()));
            }
            return matches;
        };
    }

    private static boolean passesLuhn(String cardNumber) {
        String digits = cardNumber.replaceAll("[\\s-]", "");
        if (digits.length() < 13 || digits.length() > 19) {
            return false;
        }
        int sum = 0;
        boolean alternate = false;
        for (int i = digits.length() - 1; i >= 0; --i) {
            int digit = Character.getNumericValue(digits.charAt(i));
            if (alternate && (digit *= 2) > 9) {
                digit -= 9;
            }
            sum += digit;
            alternate = !alternate;
        }
        return sum % 10 == 0;
    }
}

