/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.hook;

import java.util.List;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;

@FunctionalInterface
public interface TokenCounter {
    public static final int DEFAULT_CHARS_PER_TOKEN = 4;

    public static TokenCounter approximateMsgCounter() {
        return TokenCounter.approximateMsgCounter(4);
    }

    public static TokenCounter approximateMsgCounter(int charsPerToken) {
        return messages -> {
            int total = 0;
            for (Message msg : messages) {
                if (msg instanceof ToolResponseMessage) {
                    ToolResponseMessage toolResponseMessage = (ToolResponseMessage)msg;
                    for (ToolResponseMessage.ToolResponse response : toolResponseMessage.getResponses()) {
                        total += response.responseData().length() / charsPerToken;
                    }
                    continue;
                }
                if (msg instanceof AssistantMessage) {
                    AssistantMessage assistantMessage = (AssistantMessage)msg;
                    if (msg.getText() != null) {
                        total += msg.getText().length() / charsPerToken;
                    }
                    for (AssistantMessage.ToolCall toolCall : assistantMessage.getToolCalls()) {
                        total += toolCall.arguments().length() / charsPerToken;
                    }
                    continue;
                }
                if (msg.getText() == null) continue;
                total += msg.getText().length() / charsPerToken;
            }
            return total;
        };
    }

    public int countTokens(List<Message> var1);
}

