/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.agent.loop;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.agent.flow.agent.loop.LoopStrategy;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;

public class ConditionLoopStrategy
implements LoopStrategy {
    private final Predicate<List<Message>> messagePredicate;
    private final int maxCount = this.maxLoopCount();

    public ConditionLoopStrategy(Predicate<List<Message>> messagePredicate) {
        this.messagePredicate = messagePredicate;
    }

    @Override
    public Map<String, Object> loopInit(OverAllState state) {
        return Map.of(this.loopCountKey(), 0, this.loopFlagKey(), true);
    }

    @Override
    public Map<String, Object> loopDispatch(OverAllState state) {
        List messages = state.value("messages").orElse(List.of());
        if (this.messagePredicate.test(messages)) {
            return Map.of(this.loopFlagKey(), false);
        }
        int count = (Integer)state.value(this.loopCountKey(), (Object)this.maxCount);
        if (count < this.maxCount) {
            return Map.of(this.loopCountKey(), count + 1, this.loopFlagKey(), true);
        }
        return Map.of("messages", new SystemMessage("Max loop count reached"), this.loopFlagKey(), false);
    }
}

