/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.agent;

import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowAgentBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import org.springframework.ai.chat.model.ChatModel;

public class SupervisorAgent
extends FlowAgent {
    private final ChatModel chatModel;
    private final String systemPrompt;
    private final String instruction;

    protected SupervisorAgent(SupervisorAgentBuilder builder) {
        super(builder.name, builder.description, builder.compileConfig, builder.subAgents, builder.stateSerializer, builder.executor);
        this.chatModel = builder.chatModel;
        this.systemPrompt = builder.systemPrompt;
        this.instruction = builder.instruction;
    }

    public static SupervisorAgentBuilder builder() {
        return new SupervisorAgentBuilder();
    }

    @Override
    protected StateGraph buildSpecificGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        config.setChatModel(this.chatModel);
        return FlowGraphBuilder.buildGraph(FlowAgentEnum.SUPERVISOR.getType(), config);
    }

    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public static class SupervisorAgentBuilder
    extends FlowAgentBuilder<SupervisorAgent, SupervisorAgentBuilder> {
        private ChatModel chatModel;
        private String systemPrompt;
        private String instruction;

        public SupervisorAgentBuilder model(ChatModel chatModel) {
            this.chatModel = chatModel;
            return this;
        }

        public SupervisorAgentBuilder systemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
            return this;
        }

        public SupervisorAgentBuilder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        @Override
        protected SupervisorAgentBuilder self() {
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.chatModel == null) {
                throw new IllegalArgumentException("ChatModel must be provided for supervisor agent");
            }
        }

        @Override
        public SupervisorAgent doBuild() {
            this.validate();
            return new SupervisorAgent(this);
        }
    }
}

