/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.BiFunction;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class EditFileTool
implements BiFunction<EditFileRequest, ToolContext, String> {
    public static final String DESCRIPTION = "Performs exact string replacements in files.\n\nUsage:\n- You must use your `read_file` tool at least once before editing.\n- When editing text from read_file output, preserve exact indentation\n- ALWAYS prefer editing existing files. NEVER write new files unless explicitly required.\n- The edit will FAIL if `old_string` is not unique in the file.\n- After editing, verify the changes by using the read_file tool.\n";

    @Override
    public String apply(EditFileRequest request, ToolContext toolContext) {
        try {
            int replaceIndex;
            Path path = Paths.get(request.filePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return "Error: File not found: " + request.filePath;
            }
            String content = Files.readString(path);
            if (!content.contains(request.oldString)) {
                return "Error: String not found in file: " + request.oldString;
            }
            int count = 0;
            String temp = content;
            int index = 0;
            while ((index = temp.indexOf(request.oldString, index)) != -1) {
                ++count;
                index += request.oldString.length();
            }
            if (!request.replaceAll && count > 1) {
                return "Error: String appears " + count + " times in file. Please provide more context or use replace_all=true";
            }
            Object newContent = request.replaceAll ? content.replace(request.oldString, request.newString) : ((replaceIndex = content.indexOf(request.oldString)) != -1 ? content.substring(0, replaceIndex) + request.newString + content.substring(replaceIndex + request.oldString.length()) : content);
            Files.writeString(path, (CharSequence)newContent, new OpenOption[0]);
            return "Successfully replaced " + (request.replaceAll ? count : 1) + " occurrence(s) in " + request.filePath;
        }
        catch (IOException e) {
            return "Error editing file: " + e.getMessage();
        }
    }

    public static ToolCallback createEditFileToolCallback(String description) {
        return FunctionToolCallback.builder((String)"edit_file", (BiFunction)new EditFileTool()).description(description).inputType(EditFileRequest.class).build();
    }

    public static class EditFileRequest {
        @JsonProperty(required=true, value="file_path")
        @JsonPropertyDescription(value="The absolute path of the file to edit")
        public String filePath;
        @JsonProperty(required=true, value="old_string")
        @JsonPropertyDescription(value="The exact string to find and replace")
        public String oldString;
        @JsonProperty(required=true, value="new_string")
        @JsonPropertyDescription(value="The new string to replace with")
        public String newString;
        @JsonProperty(value="replace_all")
        @JsonPropertyDescription(value="If true, replace all occurrences; if false, only replace if unique (default: false)")
        public boolean replaceAll = false;

        public EditFileRequest() {
        }

        public EditFileRequest(String filePath, String oldString, String newString, boolean replaceAll) {
            this.filePath = filePath;
            this.oldString = oldString;
            this.newString = newString;
            this.replaceAll = replaceAll;
        }
    }
}

