/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.interceptor;

import com.alibaba.cloud.ai.graph.agent.interceptor.ModelCallHandler;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelRequest;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;

public class PatchToolCallsInterceptor
extends ModelInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PatchToolCallsInterceptor.class);
    private static final String CANCELLATION_MESSAGE_TEMPLATE = "Tool call %s with id %s was cancelled - another message came in before it could be completed.";

    private PatchToolCallsInterceptor(Builder builder) {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getName() {
        return "PatchToolCalls";
    }

    @Override
    public ModelResponse interceptModel(ModelRequest request, ModelCallHandler handler) {
        List<Message> messages = request.getMessages();
        if (messages == null || messages.isEmpty()) {
            return handler.call(request);
        }
        List<Message> patchedMessages = this.patchDanglingToolCalls(messages);
        if (patchedMessages != messages) {
            ModelRequest patchedRequest = ModelRequest.builder(request).messages(patchedMessages).build();
            return handler.call(patchedRequest);
        }
        return handler.call(request);
    }

    private List<Message> patchDanglingToolCalls(List<Message> messages) {
        ArrayList<Object> patchedMessages = new ArrayList<Object>();
        boolean hasPatches = false;
        HashSet<String> existingToolResponseIds = new HashSet<String>();
        for (Message msg : messages) {
            if (!(msg instanceof ToolResponseMessage)) continue;
            ToolResponseMessage toolResponseMsg = (ToolResponseMessage)msg;
            for (ToolResponseMessage.ToolResponse response : toolResponseMsg.getResponses()) {
                existingToolResponseIds.add(response.id());
            }
        }
        for (int i = 0; i < messages.size(); ++i) {
            AssistantMessage assistantMsg;
            List toolCalls;
            Message msg;
            msg = messages.get(i);
            patchedMessages.add(msg);
            if (!(msg instanceof AssistantMessage) || (toolCalls = (assistantMsg = (AssistantMessage)msg).getToolCalls()).isEmpty()) continue;
            ArrayList<ToolResponseMessage.ToolResponse> missingResponses = new ArrayList<ToolResponseMessage.ToolResponse>();
            for (AssistantMessage.ToolCall toolCall : toolCalls) {
                String toolCallId = toolCall.id();
                boolean hasResponse = existingToolResponseIds.contains(toolCallId);
                if (hasResponse) continue;
                String cancellationMsg = String.format(CANCELLATION_MESSAGE_TEMPLATE, toolCall.name(), toolCallId);
                missingResponses.add(new ToolResponseMessage.ToolResponse(toolCallId, toolCall.name(), cancellationMsg));
                log.info("Patching dangling tool call: {} (id: {})", (Object)toolCall.name(), (Object)toolCallId);
            }
            if (missingResponses.isEmpty()) continue;
            HashMap<String, Boolean> metadata = new HashMap<String, Boolean>();
            metadata.put("patched", true);
            patchedMessages.add(ToolResponseMessage.builder().responses(missingResponses).metadata(metadata).build());
            hasPatches = true;
        }
        return hasPatches ? patchedMessages : messages;
    }

    public static class Builder {
        public PatchToolCallsInterceptor build() {
            return new PatchToolCallsInterceptor(this);
        }
    }
}

