/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.model.request.base.JobRequest;
import com.aizuda.snailjob.model.response.base.JobResponse;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.CronUtils;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.common.util.TriggerIntervalUtils;
import com.aizuda.snailjob.server.job.task.support.JobPrepareHandler;
import com.aizuda.snailjob.server.service.service.impl.AbstractJobService;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.ExportJobVO;
import com.aizuda.snailjob.server.web.model.request.JobQueryVO;
import com.aizuda.snailjob.server.web.model.request.JobRequestWebVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.JobResponseWebVO;
import com.aizuda.snailjob.server.web.service.JobWebService;
import com.aizuda.snailjob.server.web.service.convert.JobConverter;
import com.aizuda.snailjob.server.web.service.convert.JobResponseVOConverter;
import com.aizuda.snailjob.server.web.service.handler.GroupHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobSummaryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SystemUserMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.SystemUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Service(value="jobWebCommonService")
@Validated
public class JobWebServiceImpl
extends AbstractJobService
implements JobWebService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobWebServiceImpl.class);
    private final SystemProperties systemProperties;
    private final JobMapper jobMapper;
    private final JobPrepareHandler terminalJobPrepareHandler;
    private final AccessTemplate accessTemplate;
    private final GroupHandler groupHandler;
    private final JobSummaryMapper jobSummaryMapper;
    private final SystemUserMapper systemUserMapper;

    private static Long calculateNextTriggerAt(Job job, Long time) {
        if (Objects.equals(job.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return 0L;
        }
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)job.getTriggerType());
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(job.getTriggerInterval());
        waitStrategyContext.setNextTriggerAt(time.longValue());
        return waitStrategy.computeTriggerTime(waitStrategyContext);
    }

    @Override
    public PageResult<List<JobResponseWebVO>> getJobPage(JobQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        PageDTO selectPage = (PageDTO)this.jobMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getNamespaceId, (Object)userSessionVO.getNamespaceId())).in(CollUtil.isNotEmpty(groupNames), Job::getGroupName, groupNames)).like(StrUtil.isNotBlank((CharSequence)queryVO.getJobName()), Job::getJobName, (Object)StrUtil.trim((CharSequence)queryVO.getJobName()))).like(StrUtil.isNotBlank((CharSequence)queryVO.getExecutorInfo()), Job::getExecutorInfo, (Object)StrUtil.trim((CharSequence)queryVO.getExecutorInfo()))).eq(Objects.nonNull(queryVO.getJobStatus()), Job::getJobStatus, (Object)queryVO.getJobStatus())).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).eq(Objects.nonNull(queryVO.getOwnerId()), Job::getOwnerId, (Object)queryVO.getOwnerId())).orderByDesc(Job::getId));
        List<JobResponseWebVO> jobResponseList = JobResponseVOConverter.INSTANCE.convertList(selectPage.getRecords());
        for (JobResponseWebVO jobResponseWebVO : jobResponseList) {
            if (!Objects.nonNull(jobResponseWebVO.getOwnerId()) || jobResponseWebVO.getOwnerId() <= 0L) continue;
            SystemUser systemUser = (SystemUser)this.systemUserMapper.selectById((Serializable)jobResponseWebVO.getOwnerId());
            jobResponseWebVO.setOwnerName(systemUser.getUsername());
        }
        return new PageResult<List<JobResponseWebVO>>(pageDTO, jobResponseList);
    }

    @Override
    public List<String> getTimeByCron(String cron) {
        return CronUtils.getExecuteTimeByCron((String)cron, (int)5);
    }

    @Override
    public List<JobResponseWebVO> getJobNameList(String keywords, Long jobId, String groupName) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        PageDTO selectPage = (PageDTO)this.jobMapper.selectPage((IPage)new PageDTO(1L, 100L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Job::getId, Job::getJobName}).eq(Job::getNamespaceId, (Object)userSessionVO.getNamespaceId())).like(StrUtil.isNotBlank((CharSequence)keywords), Job::getJobName, (Object)StrUtil.trim((CharSequence)keywords))).eq(StrUtil.isNotBlank((CharSequence)groupName), Job::getGroupName, (Object)groupName)).eq(Objects.nonNull(jobId), Job::getId, (Object)jobId)).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByDesc(Job::getId));
        return JobResponseVOConverter.INSTANCE.convertList(selectPage.getRecords());
    }

    private void checkTriggerInterval(JobRequestWebVO jobRequestWebVO) {
        TriggerIntervalUtils.checkTriggerInterval((String)jobRequestWebVO.getTriggerInterval(), (Integer)jobRequestWebVO.getTriggerType());
    }

    @Override
    public List<JobResponseWebVO> getJobList(String groupName) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List jobs = this.jobMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Job::getId, Job::getJobName, Job::getExecutorInfo, Job::getTaskType, Job::getLabels}).eq(Job::getNamespaceId, (Object)namespaceId)).eq(Job::getGroupName, (Object)groupName)).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByDesc(CreateDt::getCreateDt));
        return JobResponseVOConverter.INSTANCE.convertList(jobs);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importJobs(List<JobRequestWebVO> requestList) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        this.groupHandler.validateGroupExistence(StreamUtils.toSet(requestList, JobRequest::getGroupName), namespaceId);
        requestList.forEach(arg_0 -> ((JobWebServiceImpl)this).addJob(arg_0));
    }

    @Override
    public String exportJobs(ExportJobVO exportJobVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        ArrayList requestList = new ArrayList();
        PartitionTaskUtils.process(startId -> {
            List jobList = ((PageDTO)this.jobMapper.selectPage((IPage)new PageDTO(0L, 100L, Boolean.FALSE.booleanValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getNamespaceId, (Object)namespaceId)).eq(StrUtil.isNotBlank((CharSequence)exportJobVO.getGroupName()), Job::getGroupName, (Object)exportJobVO.getGroupName())).likeRight(StrUtil.isNotBlank((CharSequence)exportJobVO.getJobName()), Job::getJobName, (Object)StrUtil.trim((CharSequence)exportJobVO.getJobName()))).eq(Objects.nonNull(exportJobVO.getJobStatus()), Job::getJobStatus, (Object)exportJobVO.getJobStatus())).in(CollUtil.isNotEmpty(exportJobVO.getJobIds()), Job::getId, exportJobVO.getJobIds())).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).gt(Job::getId, (Object)startId)).orderByAsc(Job::getId))).getRecords();
            return StreamUtils.toList((Collection)jobList, JobPartitionTask::new);
        }, partitionTasks -> {
            List jobPartitionTasks = partitionTasks;
            requestList.addAll(JobConverter.INSTANCE.convertList(StreamUtils.toList((Collection)jobPartitionTasks, JobPartitionTask::getJob)));
        }, (long)0L);
        return JsonUtil.toJsonString(requestList);
    }

    protected void getJobByIdAfter(JobResponse responseBaseDTO, Job job) {
        JobResponseWebVO jobResponseWebVO = (JobResponseWebVO)responseBaseDTO;
        SystemUser systemUser = (SystemUser)this.systemUserMapper.selectById((Serializable)job.getOwnerId());
        if (Objects.nonNull(systemUser)) {
            jobResponseWebVO.setOwnerName(systemUser.getUsername());
        }
        jobResponseWebVO.setOwnerId(job.getOwnerId());
    }

    protected void updateJobPreValidator(JobRequest jobRequest) {
    }

    protected String getNamespaceId() {
        return UserSessionUtils.currentUserSession().getNamespaceId();
    }

    protected void addJobPopulate(Job job, JobRequest request) {
    }

    protected void addJobPreValidator(JobRequest request) {
    }

    @Generated
    public JobWebServiceImpl(SystemProperties systemProperties, JobMapper jobMapper, JobPrepareHandler terminalJobPrepareHandler, AccessTemplate accessTemplate, GroupHandler groupHandler, JobSummaryMapper jobSummaryMapper, SystemUserMapper systemUserMapper) {
        this.systemProperties = systemProperties;
        this.jobMapper = jobMapper;
        this.terminalJobPrepareHandler = terminalJobPrepareHandler;
        this.accessTemplate = accessTemplate;
        this.groupHandler = groupHandler;
        this.jobSummaryMapper = jobSummaryMapper;
        this.systemUserMapper = systemUserMapper;
    }

    private static class JobPartitionTask
    extends PartitionTask {
        private final Job job;

        public JobPartitionTask(@NotNull Job job) {
            this.job = job;
            this.setId(job.getId());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobPartitionTask)) {
                return false;
            }
            JobPartitionTask other = (JobPartitionTask)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Job this$job = this.getJob();
            Job other$job = other.getJob();
            return !(this$job == null ? other$job != null : !this$job.equals(other$job));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JobPartitionTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Job $job = this.getJob();
            result = result * 59 + ($job == null ? 43 : $job.hashCode());
            return result;
        }

        @Generated
        public Job getJob() {
            return this.job;
        }
    }
}

