/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.vo.JobLogQueryVO;
import com.aizuda.snailjob.server.web.model.event.WsSendEvent;
import com.aizuda.snailjob.server.web.service.JobLogService;
import com.aizuda.snailjob.server.web.timer.JobTaskLogTimerTask;
import com.aizuda.snailjob.server.web.timer.LogTimerWheel;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.common.PageQueryDO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.common.PageResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.log.JobLogMessageDO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.log.LogPageQueryDO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class JobLogServiceImpl
implements JobLogService {
    private static final Long DELAY_MILLS = 5000L;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final AccessTemplate accessTemplate;

    @Override
    public void getJobLogPage(JobLogQueryVO queryVO) {
        String sid = queryVO.getSid();
        LogPageQueryDO pageQueryDO = new LogPageQueryDO();
        pageQueryDO.setPage(1);
        pageQueryDO.setSize(50);
        pageQueryDO.setTaskBatchId(queryVO.getTaskBatchId());
        pageQueryDO.setTaskId(queryVO.getTaskId());
        pageQueryDO.setStartRealTime(queryVO.getStartRealTime());
        pageQueryDO.setSearchCount(true);
        PageResponseDO pageResponseDO = this.accessTemplate.getJobLogMessageAccess().listPage((PageQueryDO)pageQueryDO);
        long total = pageResponseDO.getTotal();
        int totalPage = (int)((total + (long)queryVO.getSize() - 1L) / (long)queryVO.getSize());
        Long lastRealTime = 0L;
        if (0 == totalPage && null != pageQueryDO.getStartRealTime() && 0L != pageQueryDO.getStartRealTime()) {
            lastRealTime = pageQueryDO.getStartRealTime();
        }
        int i = 1;
        while (i <= totalPage) {
            for (JobLogMessageDO jobLogMessageDO : pageResponseDO.getRows()) {
                lastRealTime = jobLogMessageDO.getRealTime();
                String message = jobLogMessageDO.getMessage();
                List<Map> logContents = (List<Map>)JsonUtil.parseObject((String)message, List.class);
                logContents = logContents.stream().sorted(Comparator.comparingLong(o -> Long.parseLong((String)o.get("time_stamp")))).toList();
                for (Map logContent : logContents) {
                    WsSendEvent sendEvent = new WsSendEvent(this);
                    sendEvent.setSid(sid);
                    sendEvent.setMessage(JsonUtil.toJsonString((Object)logContent));
                    SnailSpringContext.getContext().publishEvent((ApplicationEvent)sendEvent);
                }
            }
            pageQueryDO.setSearchCount(false);
            pageQueryDO.setPage(++i);
            pageResponseDO = this.accessTemplate.getJobLogMessageAccess().listPage((PageQueryDO)pageQueryDO);
        }
        JobTaskBatch jobTaskBatch = (JobTaskBatch)this.jobTaskBatchMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getId, (Object)queryVO.getTaskBatchId()));
        if (Objects.isNull(jobTaskBatch) || JobTaskBatchStatusEnum.COMPLETED.contains(jobTaskBatch.getTaskBatchStatus()) && jobTaskBatch.getUpdateDt().plusSeconds(15L).isBefore(LocalDateTime.now())) {
            WsSendEvent sendEvent = new WsSendEvent(this);
            sendEvent.setMessage("END");
            sendEvent.setSid(sid);
            SnailSpringContext.getContext().publishEvent((ApplicationEvent)sendEvent);
        } else {
            queryVO.setStartRealTime(lastRealTime);
            this.scheduleNextAttempt(queryVO, sid);
        }
    }

    private void scheduleNextAttempt(JobLogQueryVO queryVO, String sid) {
        LogTimerWheel.registerWithJobTaskLog(() -> new JobTaskLogTimerTask(queryVO, sid), Duration.ofMillis(DELAY_MILLS));
    }

    @Generated
    public JobLogServiceImpl(JobTaskBatchMapper jobTaskBatchMapper, AccessTemplate accessTemplate) {
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.accessTemplate = accessTemplate;
    }
}

