/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.annotation.RoleEnum;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.NamespaceQueryVO;
import com.aizuda.snailjob.server.web.model.request.NamespaceRequestVO;
import com.aizuda.snailjob.server.web.model.response.NamespaceResponseVO;
import com.aizuda.snailjob.server.web.service.NamespaceService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/namespace"})
public class NamespaceController {
    @Autowired
    private NamespaceService namespaceService;

    @LoginRequired(role=RoleEnum.ADMIN)
    @PostMapping
    public Boolean saveNamespace(@RequestBody @Validated NamespaceRequestVO namespaceRequestVO) {
        return this.namespaceService.saveNamespace(namespaceRequestVO);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @PutMapping
    public Boolean updateNamespace(@RequestBody @Validated NamespaceRequestVO namespaceRequestVO) {
        return this.namespaceService.updateNamespace(namespaceRequestVO);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @GetMapping(value={"list"})
    public PageResult<List<NamespaceResponseVO>> getNamespacePage(NamespaceQueryVO queryVO) {
        return this.namespaceService.getNamespacePage(queryVO);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @DeleteMapping(value={"{uniqueId}"})
    public Boolean deleteByUniqueId(@PathVariable(value="uniqueId") String uniqueId) {
        return this.namespaceService.deleteByUniqueId(uniqueId);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @GetMapping(value={"/all"})
    public List<NamespaceResponseVO> getAllNamespace() {
        return this.namespaceService.getAllNamespace();
    }
}

