/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.timer;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.job.task.dto.JobTimerTaskDTO;
import com.aizuda.snailjob.server.job.task.dto.TaskExecuteDTO;
import io.netty.util.Timeout;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import lombok.Generated;
import org.apache.pekko.actor.ActorRef;

public class JobTimerTask
implements TimerTask<String> {
    public static final String IDEMPOTENT_KEY_PREFIX = "job_{0}";
    private JobTimerTaskDTO jobTimerTaskDTO;

    public void run(Timeout timeout) throws Exception {
        SnailJobLog.LOCAL.debug("Start task scheduling. Current time:[{}] Task ID:[{}]", new Object[]{LocalDateTime.now(), this.jobTimerTaskDTO.getTaskBatchId()});
        try {
            TaskExecuteDTO taskExecuteDTO = new TaskExecuteDTO();
            taskExecuteDTO.setTaskBatchId(this.jobTimerTaskDTO.getTaskBatchId());
            taskExecuteDTO.setJobId(this.jobTimerTaskDTO.getJobId());
            taskExecuteDTO.setTaskExecutorScene(this.jobTimerTaskDTO.getTaskExecutorScene());
            taskExecuteDTO.setWorkflowTaskBatchId(this.jobTimerTaskDTO.getWorkflowTaskBatchId());
            taskExecuteDTO.setWorkflowNodeId(this.jobTimerTaskDTO.getWorkflowNodeId());
            taskExecuteDTO.setTmpArgsStr(this.jobTimerTaskDTO.getTmpArgsStr());
            ActorRef actorRef = ActorGenerator.jobTaskExecutorActor();
            actorRef.tell((Object)taskExecuteDTO, actorRef);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Task scheduling execution failed", new Object[]{e});
        }
    }

    public String idempotentKey() {
        return MessageFormat.format(IDEMPOTENT_KEY_PREFIX, this.jobTimerTaskDTO.getTaskBatchId());
    }

    @Generated
    public JobTimerTask(JobTimerTaskDTO jobTimerTaskDTO) {
        this.jobTimerTaskDTO = jobTimerTaskDTO;
    }
}

