/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.log.dialect.slf4j;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.log.dialect.AbstractLog;
import com.aizuda.snailjob.common.log.factory.LogFactory;
import com.aizuda.snailjob.common.log.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;
    private final boolean isLocationAwareLogger;

    public Slf4jLog(Logger logger) {
        this.logger = logger;
        this.isLocationAwareLogger = logger instanceof LocationAwareLogger;
    }

    public Slf4jLog(Class<?> clazz) {
        this(Slf4jLog.getSlf4jLogger(clazz));
    }

    public Slf4jLog(String name) {
        this(LoggerFactory.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(Boolean remote, String fqcn, String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.setContextMap(remote);
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 0, LogFactory.extractThrowable(arguments), format, arguments);
            } else {
                this.logger.trace(format, arguments);
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(Boolean remote, String fqcn, String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.setContextMap(remote);
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 10, LogFactory.extractThrowable(arguments), format, arguments);
            } else {
                this.logger.debug(format, arguments);
            }
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(Boolean remote, String fqcn, String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.setContextMap(remote);
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 20, LogFactory.extractThrowable(arguments), format, arguments);
            } else {
                this.logger.info(format, arguments);
            }
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(Boolean remote, String fqcn, String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.setContextMap(remote);
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 30, LogFactory.extractThrowable(arguments), format, arguments);
            } else {
                this.logger.warn(format, arguments);
            }
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(Boolean remote, String fqcn, String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.setContextMap(remote);
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 40, LogFactory.extractThrowable(arguments), format, arguments);
            } else {
                this.logger.error(format, arguments);
            }
        }
    }

    @Override
    public void log(Level level, Boolean remote, String fqcn, String format, Object ... arguments) {
        switch (level) {
            case TRACE: {
                this.trace(remote, fqcn, format, arguments);
                break;
            }
            case DEBUG: {
                this.debug(remote, fqcn, format, arguments);
                break;
            }
            case INFO: {
                this.info(remote, fqcn, format, arguments);
                break;
            }
            case WARN: {
                this.warn(remote, fqcn, format, arguments);
                break;
            }
            case ERROR: {
                this.error(remote, fqcn, format, arguments);
                break;
            }
            case OFF: {
                break;
            }
            default: {
                throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
            }
        }
    }

    private void locationAwareLog(LocationAwareLogger logger, String fqcn, int level_int, Throwable t, String msgTemplate, Object[] arguments) {
        logger.log(null, fqcn, level_int, msgTemplate, arguments, t);
    }

    private static Logger getSlf4jLogger(Class<?> clazz) {
        return null == clazz ? LoggerFactory.getLogger((String)"") : LoggerFactory.getLogger(clazz);
    }

    private void setContextMap(Boolean remote) {
        if (remote.booleanValue()) {
            MDC.put((String)"remote", (String)remote.toString());
        }
    }
}

