/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.log.dialect.console;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.log.dialect.AbstractLog;
import com.aizuda.snailjob.common.log.dialect.console.Console;
import com.aizuda.snailjob.common.log.dialect.console.ConsoleLogFactory;
import com.aizuda.snailjob.common.log.level.Level;
import java.util.Map;

public class ConsoleLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String logFormat = "[{date}] [{level}] {name}: {msg}";
    private static Level currentLevel = Level.DEBUG;
    private final String name;

    public ConsoleLog(Class<?> clazz) {
        this.name = null == clazz ? "null" : clazz.getName();
    }

    public ConsoleLog(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static void setLevel(Level customLevel) {
        Assert.notNull((Object)((Object)customLevel));
        currentLevel = customLevel;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public void trace(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.log(Level.TRACE, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public void debug(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.log(Level.DEBUG, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public void info(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.log(Level.INFO, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    @Override
    public void warn(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.log(Level.WARN, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    @Override
    public void error(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.log(Level.ERROR, remote, fqcn, format, arguments);
    }

    @Override
    public void log(Level level, Boolean remote, String fqcn, String format, Object ... arguments) {
        if (!this.isEnabled(level)) {
            return;
        }
        Dict dict = Dict.create().set("date", (Object)DateUtil.now()).set("level", (Object)level.toString()).set("name", (Object)this.name).set("msg", (Object)StrUtil.format((CharSequence)format, (Object[])arguments));
        String logMsg = StrUtil.format((CharSequence)logFormat, (Map)dict);
        if (level.ordinal() >= Level.WARN.ordinal()) {
            Console.error(ConsoleLogFactory.extractThrowable(arguments), logMsg, new Object[0]);
        } else {
            Console.log(ConsoleLogFactory.extractThrowable(arguments), logMsg, new Object[0]);
        }
    }

    @Override
    public boolean isEnabled(Level level) {
        return currentLevel.compareTo(level) <= 0;
    }
}

