/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client;

import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.common.rpc.client.RpcClientInvokeHandler;
import com.aizuda.snailjob.client.common.rpc.client.grpc.GrpcClientInvokeHandler;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.RpcTypeEnum;
import com.aizuda.snailjob.common.core.model.Result;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class RequestBuilder<T, R extends Result<Object>> {
    private Class<T> clintInterface;
    private Consumer<R> callback;
    private boolean async = true;
    private long timeout = 60000L;
    private TimeUnit unit = TimeUnit.MILLISECONDS;

    public static <T, R extends Result<Object>> RequestBuilder<T, R> newBuilder() {
        return new RequestBuilder<T, R>();
    }

    public RequestBuilder<T, R> client(Class<T> clintInterface) {
        this.clintInterface = clintInterface;
        return this;
    }

    public RequestBuilder<T, R> callback(Consumer<R> callback) {
        this.callback = callback;
        return this;
    }

    public RequestBuilder<T, R> async(boolean async) {
        this.async = async;
        return this;
    }

    public RequestBuilder<T, R> timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public RequestBuilder<T, R> unit(TimeUnit unit) {
        this.unit = unit;
        return this;
    }

    public T build() {
        if (Objects.isNull(this.clintInterface)) {
            throw new SnailJobClientException("clintInterface cannot be null");
        }
        try {
            this.clintInterface = Class.forName(this.clintInterface.getName());
        }
        catch (Exception e) {
            throw new SnailJobClientException("class not found exception to: [{}]", (Object)this.clintInterface.getName());
        }
        SnailJobProperties properties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        RpcTypeEnum rpcType = properties.getRpcType();
        InvocationHandler invocationHandler = Objects.isNull(rpcType) || RpcTypeEnum.NETTY == rpcType ? new RpcClientInvokeHandler<R>(this.async, this.timeout, this.unit, this.callback) : new GrpcClientInvokeHandler<R>(this.async, this.timeout, this.unit, this.callback);
        return (T)Proxy.newProxyInstance(this.clintInterface.getClassLoader(), new Class[]{this.clintInterface}, invocationHandler);
    }
}

