/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.qdrant;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.store.DocumentStore;
import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.core.util.CollectionUtil;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.core.util.VectorUtil;
import com.agentsflex.store.qdrant.QdrantVectorStoreConfig;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.TlsChannelCredentials;
import io.qdrant.client.ConditionFactory;
import io.qdrant.client.PointIdFactory;
import io.qdrant.client.QdrantClient;
import io.qdrant.client.QdrantGrpcClient;
import io.qdrant.client.QueryFactory;
import io.qdrant.client.ValueFactory;
import io.qdrant.client.VectorsFactory;
import io.qdrant.client.WithPayloadSelectorFactory;
import io.qdrant.client.grpc.Collections;
import io.qdrant.client.grpc.JsonWithInt;
import io.qdrant.client.grpc.Points;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class QdrantVectorStore
extends DocumentStore {
    private final QdrantVectorStoreConfig config;
    private final QdrantClient client;
    private final String defaultCollectionName;
    private boolean isCreateCollection = false;

    public QdrantVectorStore(QdrantVectorStoreConfig config) throws IOException {
        QdrantGrpcClient.Builder builder;
        this.config = config;
        this.defaultCollectionName = config.getDefaultCollectionName();
        String uri = config.getUri();
        int port = 6334;
        if (StringUtil.hasText((String)config.getCaPath())) {
            ManagedChannel channel = Grpc.newChannelBuilder((String)uri, (ChannelCredentials)TlsChannelCredentials.newBuilder().trustManager(new File(config.getCaPath())).build()).build();
            builder = QdrantGrpcClient.newBuilder((ManagedChannel)channel, (boolean)true);
        } else {
            if (uri.contains(":")) {
                uri = uri.split(":")[0];
                port = Integer.parseInt(uri.split(":")[1]);
            }
            builder = QdrantGrpcClient.newBuilder((String)uri, (int)port, (boolean)false);
        }
        if (StringUtil.hasText((String)config.getApiKey())) {
            builder.withApiKey(config.getApiKey());
        }
        this.client = new QdrantClient(builder.build());
    }

    public StoreResult storeInternal(List<Document> documents, StoreOptions options) {
        ArrayList<Points.PointStruct> points = new ArrayList<Points.PointStruct>();
        int size = 1024;
        for (Document doc : documents) {
            size = doc.getVector().length;
            HashMap<String, JsonWithInt.Value> payload = new HashMap<String, JsonWithInt.Value>();
            payload.put("content", ValueFactory.value((String)doc.getContent()));
            points.add(Points.PointStruct.newBuilder().setId(PointIdFactory.id((long)Long.parseLong(doc.getId().toString()))).setVectors(VectorsFactory.vectors((float[])VectorUtil.toFloatArray((double[])doc.getVector()))).putAllPayload(payload).build());
        }
        try {
            String collectionName = options.getCollectionNameOrDefault(this.defaultCollectionName);
            if (this.config.isAutoCreateCollection() && !this.isCreateCollection) {
                Boolean exists = (Boolean)this.client.collectionExistsAsync(collectionName).get();
                if (!exists.booleanValue()) {
                    this.client.createCollectionAsync(collectionName, Collections.VectorParams.newBuilder().setDistance(Collections.Distance.Cosine).setSize((long)size).build()).get();
                }
            } else {
                this.isCreateCollection = true;
            }
            if (CollectionUtil.hasItems(points)) {
                this.client.upsertAsync(collectionName, points).get();
            }
            return StoreResult.successWithIds(documents);
        }
        catch (Exception e) {
            return StoreResult.fail();
        }
    }

    public StoreResult deleteInternal(Collection<?> ids, StoreOptions options) {
        try {
            String collectionName = options.getCollectionNameOrDefault(this.defaultCollectionName);
            List pointIds = ids.stream().map(id -> PointIdFactory.id((long)((Long)id))).collect(Collectors.toList());
            this.client.deleteAsync(collectionName, pointIds).get();
            return StoreResult.success();
        }
        catch (Exception e) {
            return StoreResult.fail();
        }
    }

    public StoreResult updateInternal(List<Document> documents, StoreOptions options) {
        try {
            ArrayList<Points.PointStruct> points = new ArrayList<Points.PointStruct>();
            for (Document doc : documents) {
                HashMap<String, JsonWithInt.Value> payload = new HashMap<String, JsonWithInt.Value>();
                payload.put("content", ValueFactory.value((String)doc.getContent()));
                points.add(Points.PointStruct.newBuilder().setId(PointIdFactory.id((long)Long.parseLong(doc.getId().toString()))).setVectors(VectorsFactory.vectors((float[])VectorUtil.toFloatArray((double[])doc.getVector()))).putAllPayload(payload).build());
            }
            String collectionName = options.getCollectionNameOrDefault(this.defaultCollectionName);
            if (CollectionUtil.hasItems(points)) {
                this.client.upsertAsync(collectionName, points).get();
            }
            return StoreResult.successWithIds(documents);
        }
        catch (Exception e) {
            return StoreResult.fail();
        }
    }

    public List<Document> searchInternal(SearchWrapper wrapper, StoreOptions options) {
        ArrayList<Document> documents = new ArrayList<Document>();
        try {
            String collectionName = options.getCollectionNameOrDefault(this.defaultCollectionName);
            Points.QueryPoints.Builder query = Points.QueryPoints.newBuilder().setCollectionName(collectionName).setLimit((long)wrapper.getMaxResults().intValue()).setWithVectors(Points.WithVectorsSelector.newBuilder().setEnable(true).build()).setWithPayload(WithPayloadSelectorFactory.enable((boolean)true));
            if (wrapper.getVector() != null) {
                query.setQuery(QueryFactory.nearest((float[])VectorUtil.toFloatArray((double[])wrapper.getVector())));
            }
            if (StringUtil.hasText((String)wrapper.getText())) {
                query.setFilter(Points.Filter.newBuilder().addMust(ConditionFactory.matchKeyword((String)"content", (String)wrapper.getText())));
            }
            List data = (List)this.client.queryAsync(query.build()).get();
            for (Points.ScoredPoint point : data) {
                Document doc = new Document();
                doc.setId((Object)point.getId().getNum());
                doc.setVector(VectorUtil.convertToVector((List)point.getVectors().getVector().getDataList()));
                doc.setContent(((JsonWithInt.Value)point.getPayloadMap().get("content")).getStringValue());
                documents.add(doc);
            }
            return documents;
        }
        catch (Exception e) {
            return documents;
        }
    }

    public QdrantClient getClient() {
        return this.client;
    }
}

