/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.chroma;

import com.agentsflex.core.store.DocumentStoreConfig;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromaVectorStoreConfig
implements DocumentStoreConfig {
    private static final Logger logger = LoggerFactory.getLogger(ChromaVectorStoreConfig.class);
    private String host = "localhost";
    private int port = 8000;
    private String collectionName;
    private boolean autoCreateCollection = true;
    private String apiKey;
    private String tenant;
    private String database;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public boolean isAutoCreateCollection() {
        return this.autoCreateCollection;
    }

    public void setAutoCreateCollection(boolean autoCreateCollection) {
        this.autoCreateCollection = autoCreateCollection;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public boolean checkAvailable() {
        try {
            URL url = new URL(this.getBaseUrl() + "/api/v2/heartbeat");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            if (this.apiKey != null && !this.apiKey.isEmpty()) {
                connection.setRequestProperty("X-Chroma-Token", this.apiKey);
            }
            int responseCode = connection.getResponseCode();
            connection.disconnect();
            return responseCode == 200;
        }
        catch (IOException e) {
            logger.warn("Chroma database is not available: {}", (Object)e.getMessage());
            return false;
        }
    }

    public String getBaseUrl() {
        return "http://" + this.host + ":" + this.port;
    }
}

