/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.aliyun;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.store.DocumentStore;
import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.store.aliyun.AliyunVectorStoreConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunVectorStore
extends DocumentStore {
    private static final Logger LOG = LoggerFactory.getLogger(AliyunVectorStore.class);
    private AliyunVectorStoreConfig config;
    private final HttpClient httpUtil = new HttpClient();

    public AliyunVectorStore(AliyunVectorStoreConfig config) {
        this.config = config;
    }

    public StoreResult storeInternal(List<Document> documents, StoreOptions options) {
        if (documents == null || documents.isEmpty()) {
            return StoreResult.success();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("dashvector-auth-token", this.config.getApiKey());
        HashMap payloadMap = new HashMap();
        ArrayList payloadDocs = new ArrayList();
        for (Document vectorDocument : documents) {
            HashMap<String, Object> document = new HashMap<String, Object>();
            if (vectorDocument.getMetadataMap() != null) {
                document.put("fields", vectorDocument.getMetadataMap());
            }
            document.put("vector", vectorDocument.getVector());
            document.put("id", vectorDocument.getId());
            payloadDocs.add(document);
        }
        payloadMap.put("docs", payloadDocs);
        String payload = JSON.toJSONString(payloadMap);
        String url = "https://" + this.config.getEndpoint() + "/v1/collections/" + options.getCollectionNameOrDefault(this.config.getDefaultCollectionName()) + "/docs";
        String response = this.httpUtil.post(url, headers, payload);
        if (StringUtil.noText((String)response)) {
            return StoreResult.fail();
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        Integer code = jsonObject.getInteger("code");
        if (code != null && code == 0) {
            return StoreResult.successWithIds(documents);
        }
        LOG.error("delete vector fail: " + response);
        return StoreResult.fail();
    }

    public StoreResult deleteInternal(Collection<?> ids, StoreOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("dashvector-auth-token", this.config.getApiKey());
        HashMap payloadMap = new HashMap();
        payloadMap.put("ids", ids);
        String payload = JSON.toJSONString(payloadMap);
        String url = "https://" + this.config.getEndpoint() + "/v1/collections/" + options.getCollectionNameOrDefault(this.config.getDefaultCollectionName()) + "/docs";
        String response = this.httpUtil.delete(url, headers, payload);
        if (StringUtil.noText((String)response)) {
            return StoreResult.fail();
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        Integer code = jsonObject.getInteger("code");
        if (code != null && code == 0) {
            return StoreResult.success();
        }
        LOG.error("delete vector fail: " + response);
        return StoreResult.fail();
    }

    public StoreResult updateInternal(List<Document> documents, StoreOptions options) {
        if (documents == null || documents.isEmpty()) {
            return StoreResult.success();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("dashvector-auth-token", this.config.getApiKey());
        HashMap payloadMap = new HashMap();
        ArrayList payloadDocs = new ArrayList();
        for (Document vectorDocument : documents) {
            HashMap<String, Object> document = new HashMap<String, Object>();
            if (vectorDocument.getMetadataMap() != null) {
                document.put("fields", vectorDocument.getMetadataMap());
            }
            document.put("vector", vectorDocument.getVector());
            document.put("id", vectorDocument.getId());
            payloadDocs.add(document);
        }
        payloadMap.put("docs", payloadDocs);
        String payload = JSON.toJSONString(payloadMap);
        String url = "https://" + this.config.getEndpoint() + "/v1/collections/" + options.getCollectionNameOrDefault(this.config.getDefaultCollectionName()) + "/docs";
        String response = this.httpUtil.put(url, headers, payload);
        if (StringUtil.noText((String)response)) {
            return StoreResult.fail();
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        Integer code = jsonObject.getInteger("code");
        if (code != null && code == 0) {
            return StoreResult.successWithIds(documents);
        }
        LOG.error("delete vector fail: " + response);
        return StoreResult.fail();
    }

    public List<Document> searchInternal(SearchWrapper wrapper, StoreOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("dashvector-auth-token", this.config.getApiKey());
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("vector", wrapper.getVector());
        payloadMap.put("topk", wrapper.getMaxResults());
        payloadMap.put("include_vector", wrapper.isWithVector());
        payloadMap.put("filter", wrapper.toFilterExpression());
        String payload = JSON.toJSONString(payloadMap);
        String url = "https://" + this.config.getEndpoint() + "/v1/collections/" + options.getCollectionNameOrDefault(this.config.getDefaultCollectionName()) + "/query";
        String result = this.httpUtil.post(url, headers, payload);
        if (StringUtil.noText((String)result)) {
            return null;
        }
        JSONObject rootObject = JSON.parseObject((String)result);
        int code = rootObject.getIntValue("code");
        if (code != 0) {
            LoggerFactory.getLogger(AliyunVectorStore.class).error("can not search data AliyunVectorStore\uff08code: " + code + "), message: " + rootObject.getString("message"));
            return null;
        }
        JSONArray output = rootObject.getJSONArray("output");
        ArrayList<Document> documents = new ArrayList<Document>(output.size());
        for (int i = 0; i < output.size(); ++i) {
            JSONObject jsonObject = output.getJSONObject(i);
            Document document = new Document();
            document.setId((Object)jsonObject.getString("id"));
            document.setVector((double[])jsonObject.getObject("vector", double[].class));
            Double distance = jsonObject.getDouble("score");
            if (distance != null) {
                double score = distance / 2.0;
                document.setScore(Double.valueOf(1.0 - score));
            }
            JSONObject fields = jsonObject.getJSONObject("fields");
            document.addMetadata((Map)fields);
            documents.add(document);
        }
        return documents;
    }
}

