/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.engine.es;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import co.elastic.clients.util.ObjectBuilder;
import com.agentsflex.core.document.Document;
import com.agentsflex.engine.es.ESConfig;
import com.agentsflex.search.engine.service.DocumentSearcher;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearcher
implements DocumentSearcher {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearcher.class);
    private final ESConfig esConfig;

    public ElasticSearcher(ESConfig esConfig) {
        this.esConfig = esConfig;
    }

    private RestClient buildRestClient() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.esConfig.getUserName(), this.esConfig.getPassword()));
        return RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)this.esConfig.getHost())}).setHttpClientConfigCallback(arg_0 -> ElasticSearcher.lambda$buildRestClient$1(sslContext, (CredentialsProvider)credentialsProvider, arg_0)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDocument(Document document) {
        boolean bl;
        if (document == null || document.getContent() == null) {
            return false;
        }
        RestClient restClient = null;
        RestClientTransport transport = null;
        try {
            String documentId;
            IndexOperation indexOp;
            BulkOperation bulkOp;
            BulkRequest request;
            BulkResponse response;
            restClient = this.buildRestClient();
            transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
            ElasticsearchClient client = new ElasticsearchClient((ElasticsearchTransport)transport);
            HashMap<String, Object> source = new HashMap<String, Object>();
            source.put("id", document.getId());
            source.put("content", document.getContent());
            if (document.getTitle() != null) {
                source.put("title", document.getTitle());
            }
            bl = !(response = client.bulk(request = BulkRequest.of(arg_0 -> ElasticSearcher.lambda$addDocument$4(bulkOp = BulkOperation.of(arg_0 -> ElasticSearcher.lambda$addDocument$3(indexOp = IndexOperation.of(arg_0 -> this.lambda$addDocument$2(documentId = document.getId().toString(), source, arg_0)), arg_0)), arg_0)))).errors();
        }
        catch (Exception e) {
            boolean bl2;
            try {
                LOG.error(e.getMessage(), (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                this.closeResources(new AutoCloseable[]{transport, restClient});
                throw throwable;
            }
            this.closeResources(new AutoCloseable[]{transport, restClient});
            return bl2;
        }
        this.closeResources(new AutoCloseable[]{transport, restClient});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> searchDocuments(String keyword, int count) {
        ArrayList<Document> arrayList;
        RestClient restClient = null;
        RestClientTransport transport = null;
        try {
            restClient = this.buildRestClient();
            transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
            ElasticsearchClient client = new ElasticsearchClient((ElasticsearchTransport)transport);
            SearchRequest request = SearchRequest.of(s -> s.index(this.esConfig.getIndexName(), new String[0]).size(Integer.valueOf(count)).query(q -> q.match(m -> m.field("title").field("content").query(keyword))));
            SearchResponse response = client.search(request, Document.class);
            ArrayList<Document> results = new ArrayList<Document>();
            response.hits().hits().forEach(hit -> results.add((Document)hit.source()));
            arrayList = results;
        }
        catch (Exception e) {
            List<Document> list;
            try {
                LOG.error(e.getMessage(), (Throwable)e);
                list = Collections.emptyList();
            }
            catch (Throwable throwable) {
                this.closeResources(new AutoCloseable[]{transport, restClient});
                throw throwable;
            }
            this.closeResources(new AutoCloseable[]{transport, restClient});
            return list;
        }
        this.closeResources(new AutoCloseable[]{transport, restClient});
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDocument(Object id) {
        boolean bl;
        if (id == null) {
            return false;
        }
        RestClient restClient = null;
        RestClientTransport transport = null;
        try {
            restClient = this.buildRestClient();
            transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
            ElasticsearchClient client = new ElasticsearchClient((ElasticsearchTransport)transport);
            DeleteRequest request = DeleteRequest.of(d -> d.index(this.esConfig.getIndexName()).id(id.toString()));
            DeleteResponse response = client.delete(request);
            bl = response.result() == Result.Deleted;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                LOG.error("Error deleting document with id: " + id, (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                this.closeResources(new AutoCloseable[]{transport, restClient});
                throw throwable;
            }
            this.closeResources(new AutoCloseable[]{transport, restClient});
            return bl2;
        }
        this.closeResources(new AutoCloseable[]{transport, restClient});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDocument(Document document) {
        boolean bl;
        if (document == null || document.getId() == null) {
            return false;
        }
        RestClient restClient = null;
        RestClientTransport transport = null;
        try {
            restClient = this.buildRestClient();
            transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
            ElasticsearchClient client = new ElasticsearchClient((ElasticsearchTransport)transport);
            UpdateRequest request = UpdateRequest.of(u -> u.index(this.esConfig.getIndexName()).id(document.getId().toString()).doc((Object)document));
            UpdateResponse response = client.update(request, Object.class);
            bl = response.result() == Result.Updated;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                LOG.error("Error updating document with id: " + document.getId(), (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                this.closeResources(new AutoCloseable[]{transport, restClient});
                throw throwable;
            }
            this.closeResources(new AutoCloseable[]{transport, restClient});
            return bl2;
        }
        this.closeResources(new AutoCloseable[]{transport, restClient});
        return bl;
    }

    private void closeResources(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Exception e) {
                LOG.error("Error closing resource", (Throwable)e);
            }
        }
    }

    private static /* synthetic */ ObjectBuilder lambda$addDocument$4(BulkOperation bulkOp, BulkRequest.Builder b) {
        return b.operations(Collections.singletonList(bulkOp));
    }

    private static /* synthetic */ ObjectBuilder lambda$addDocument$3(IndexOperation indexOp, BulkOperation.Builder b) {
        return b.index(indexOp);
    }

    private /* synthetic */ ObjectBuilder lambda$addDocument$2(String documentId, Map source, IndexOperation.Builder i) {
        return ((IndexOperation.Builder)((IndexOperation.Builder)i.index(this.esConfig.getIndexName())).id(documentId)).document((Object)JsonData.of((Object)source));
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$buildRestClient$1(SSLContext sslContext, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setSSLContext(sslContext);
        httpClientBuilder.setSSLHostnameVerifier((hostname, session) -> true);
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        return httpClientBuilder;
    }
}

