/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.siliconflow;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.LogUtil;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.siliconflow.SiliconflowConfig;
import com.agentsflex.llm.siliconflow.SiliconflowLlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class SiliconflowLlm
extends BaseLlm<SiliconflowConfig> {
    private final Map<String, String> headers = new HashMap<String, String>();
    private final HttpClient httpClient = new HttpClient();
    private final AiMessageParser aiMessageParser = SiliconflowLlmUtil.getAiMessageParser(false);
    private final AiMessageParser streamMessageParser = SiliconflowLlmUtil.getAiMessageParser(true);

    public SiliconflowLlm(SiliconflowConfig config) {
        super((LlmConfig)config);
        this.headers.put("Content-Type", "application/json");
        this.headers.put("Accept", "application/json");
        this.headers.put("Authorization", "Bearer " + ((SiliconflowConfig)this.getConfig()).getApiKey());
    }

    public static SiliconflowLlm of(String apiKey) {
        SiliconflowConfig config = new SiliconflowConfig();
        config.setApiKey(apiKey);
        return new SiliconflowLlm(config);
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        Consumer headersConfig = ((SiliconflowConfig)this.config).getHeadersConfig();
        if (headersConfig != null) {
            headersConfig.accept(this.headers);
        }
        String payload = SiliconflowLlmUtil.promptToPayload(prompt, this.config, options, false);
        String endpoint = ((SiliconflowConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/chat/completions", this.headers, payload);
        if (((SiliconflowConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return AiMessageResponse.error((Prompt)prompt, (String)response, (String)"no content for response.");
        }
        if (response.startsWith("{")) {
            JSONObject jsonObject = JSON.parseObject((String)response);
            Integer code = jsonObject.getInteger("code");
            if (code != null) {
                return AiMessageResponse.error((Prompt)prompt, (String)response, (String)jsonObject.getString("message"));
            }
            return new AiMessageResponse(prompt, response, (AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        }
        return AiMessageResponse.error((Prompt)prompt, (String)response, (String)response);
    }

    public void chatStream(Prompt prompt, StreamResponseListener streamResponseListener, ChatOptions chatOptions) {
        SseClient llmClient = new SseClient();
        String payload = SiliconflowLlmUtil.promptToPayload(prompt, this.config, chatOptions, true);
        String endpoint = ((SiliconflowConfig)this.config).getEndpoint();
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, streamResponseListener, prompt, this.streamMessageParser);
        llmClient.start(endpoint + "/chat/completions", this.headers, payload, (LlmClientListener)clientListener, this.config);
    }

    public void chatStream(Prompt prompt, StreamResponseListener streamResponseListener) {
        this.chatStream(prompt, streamResponseListener, ChatOptions.DEFAULT);
    }

    public VectorData embed(Document document, EmbeddingOptions embeddingOptions) {
        Consumer headersConfig = ((SiliconflowConfig)this.config).getHeadersConfig();
        if (headersConfig != null) {
            headersConfig.accept(this.headers);
        }
        String payload = SiliconflowLlmUtil.documentToPayload(document, (SiliconflowConfig)this.config, embeddingOptions);
        String endpoint = ((SiliconflowConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/embeddings", this.headers, payload);
        if (((SiliconflowConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return null;
        }
        if (response.startsWith("{")) {
            JSONObject jsonObject = JSON.parseObject((String)response);
            Integer code = jsonObject.getInteger("code");
            if (code != null) {
                return null;
            }
            VectorData vectorData = new VectorData();
            vectorData.setVector((double[])JSONPath.read((String)response, (String)"$.data[0].embedding", double[].class));
            return vectorData;
        }
        return null;
    }
}

