/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.image.qianfan;

import com.agentsflex.core.image.EditImageRequest;
import com.agentsflex.core.image.GenerateImageRequest;
import com.agentsflex.core.image.ImageModel;
import com.agentsflex.core.image.ImageResponse;
import com.agentsflex.core.image.VaryImageRequest;
import com.agentsflex.core.util.Maps;
import com.agentsflex.image.qianfan.QianfanImageModelConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class QianfanImageModel
implements ImageModel {
    static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();
    private QianfanImageModelConfig config;

    public QianfanImageModel(QianfanImageModelConfig config) {
        this.config = config;
    }

    public ImageResponse generate(GenerateImageRequest request) {
        ImageResponse responseImage = new ImageResponse();
        try {
            request.setModel(this.config.getModels());
            String payload = QianfanImageModel.promptToPayload(request);
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)payload);
            Request requestQianfan = new Request.Builder().url(this.config.getEndpoint() + this.config.getEndpointGenerations()).post(body).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.config.getApiKey()).build();
            Response response = HTTP_CLIENT.newCall(requestQianfan).execute();
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            JSONObject jsonObject = JSON.parseObject((String)response.body().string());
            JSONArray dataArray = jsonObject.getJSONArray("data");
            for (int i = 0; i < dataArray.size(); ++i) {
                responseImage.addImage(dataArray.getJSONObject(i).getString("url"));
            }
            return responseImage;
        }
        catch (IOException e) {
            ImageResponse.error((String)e.getMessage());
            e.printStackTrace();
            return responseImage;
        }
        catch (Exception e) {
            ImageResponse.error((String)e.getMessage());
            e.printStackTrace();
            return responseImage;
        }
    }

    public static String promptToPayload(GenerateImageRequest request) {
        return Maps.of((String)"Prompt", (Object)request.getPrompt()).setIfNotEmpty("model", (Object)request.getModel()).toJSON();
    }

    public ImageResponse img2imggenerate(GenerateImageRequest request) {
        return null;
    }

    public ImageResponse edit(EditImageRequest request) {
        return null;
    }

    public ImageResponse vary(VaryImageRequest request) {
        return null;
    }
}

