/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import okio.BufferedSink;

public class IOUtil {
    public static void writeBytes(byte[] bytes, File toFile) {
        try (FileOutputStream stream = new FileOutputStream(toFile);){
            stream.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] byArray = IOUtil.readBytes(inputStream);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readBytes(InputStream inputStream) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            IOUtil.copy(inputStream, outStream);
            return outStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copy(InputStream inputStream, BufferedSink sink) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            sink.write(buffer, 0, len);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outStream) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
    }

    public static String readUtf8(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        IOUtil.copy(inputStream, outStream);
        return new String(outStream.toByteArray(), StandardCharsets.UTF_8);
    }
}

