/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.store.condition;

import com.agentsflex.core.store.condition.Condition;
import com.agentsflex.core.store.condition.ConditionType;
import com.agentsflex.core.store.condition.Connector;
import com.agentsflex.core.store.condition.Group;
import com.agentsflex.core.store.condition.Operand;
import java.util.StringJoiner;

public interface ExpressionAdaptor {
    public static final ExpressionAdaptor DEFAULT = new ExpressionAdaptor(){};

    default public String toCondition(Condition condition) {
        return this.toLeft(condition.left) + this.toOperationSymbol(condition.type) + this.toRight(condition.right);
    }

    default public String toLeft(Operand operand) {
        return operand.toExpression(this);
    }

    default public String toOperationSymbol(ConditionType type) {
        return type.getDefaultSymbol();
    }

    default public String toRight(Operand operand) {
        return operand.toExpression(this);
    }

    default public String toValue(Condition condition, Object value) {
        if (condition.getType() == ConditionType.BETWEEN) {
            Object[] values = (Object[])value;
            return "\"" + values[0] + "\" AND \"" + values[1] + "\"";
        }
        if (condition.getType() == ConditionType.IN) {
            Object[] values = (Object[])value;
            StringJoiner stringJoiner = new StringJoiner(",", "(", ")");
            for (Object v : values) {
                if (v == null) continue;
                stringJoiner.add("\"" + v + "\"");
            }
            return stringJoiner.toString();
        }
        return value == null ? "" : "\"" + value + "\"";
    }

    default public String toConnector(Connector connector) {
        return connector.getValue();
    }

    default public String toGroupStart(Group group) {
        return "(";
    }

    default public String toGroupEnd(Group group) {
        return ")";
    }
}

