/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.react;

import com.agentsflex.core.react.ReActStep;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface ReActStepParser {
    public static final ReActStepParser DEFAULT = new ReActStepParser(){
        private final Pattern STEP_PATTERN = Pattern.compile("Thought: (.*?)\nAction: (.*?)\nAction Input: (\\{[\\s\\S]*})", 32);

        @Override
        public List<ReActStep> parse(String content) {
            ArrayList<ReActStep> steps = new ArrayList<ReActStep>();
            Matcher matcher = this.STEP_PATTERN.matcher(content);
            while (matcher.find()) {
                String thought = matcher.group(1).trim();
                String action = matcher.group(2).trim();
                String actionInput = matcher.group(3).trim();
                steps.add(new ReActStep(thought, action, actionInput));
            }
            return steps;
        }
    };

    public List<ReActStep> parse(String var1);

    default public boolean isFinalAnswer(String content) {
        return content.contains(this.getFinalAnswerFlag());
    }

    default public boolean isReActAction(String content) {
        return content.contains("Action:") && content.contains("Action Input:");
    }

    default public String getFinalAnswerFlag() {
        return "Final Answer:";
    }
}

