/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.react;

import com.agentsflex.core.llm.functions.Function;
import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.react.ReActStep;
import java.util.List;

public class ReActMessageBuilder {
    public Message buildStartMessage(String prompt, List<Function> functions, String userQuery) {
        HumanMessage message = new HumanMessage(prompt);
        message.addMetadata("tools", functions);
        message.addMetadata("user_input", userQuery);
        message.addMetadata("type", "reActWrapper");
        return message;
    }

    public Message buildJsonParserErrorMessage(Exception e, ReActStep step) {
        String errorMsg = "JSON \u89e3\u6790\u5931\u8d25: " + e.getMessage() + ", \u539f\u59cb\u5185\u5bb9: " + step.getActionInput();
        String observation = "Action\uff1a" + step.getAction() + "\nAction Input\uff1a" + step.getActionInput() + "\nError\uff1a" + errorMsg + "\n\u8bf7\u68c0\u67e5\u4f60\u7684 Action Input \u683c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u5e76\u7ea0\u6b63 JSON \u5185\u5bb9\u91cd\u65b0\u751f\u6210\u54cd\u5e94\u3002\n";
        HumanMessage humanMessage = new HumanMessage(observation + "\u8bf7\u7ee7\u7eed\u63a8\u7406\u4e0b\u4e00\u6b65\u3002");
        humanMessage.addMetadata("type", "reActObservation");
        return humanMessage;
    }

    public Message buildObservationMessage(ReActStep step, Object result) {
        String observation = ReActMessageBuilder.buildObservationString(step, result);
        HumanMessage humanMessage = new HumanMessage(observation + "\n\u8bf7\u7ee7\u7eed\u63a8\u7406\u4e0b\u4e00\u6b65\u3002");
        humanMessage.addMetadata("type", "reActObservation");
        return humanMessage;
    }

    public static String buildObservationString(ReActStep step, Object result) {
        return "Action\uff1a" + step.getAction() + "\nAction Input\uff1a" + step.getActionInput() + "\nAction Result\uff1a" + result + "\n";
    }

    public Message buildActionErrorMessage(ReActStep step, Exception e) {
        String observation = ReActMessageBuilder.buildObservationString(step, "Error: " + e.getMessage()) + "\n\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u8c03\u6574\u53c2\u6570\u5e76\u91cd\u65b0\u5c1d\u8bd5\u3002\n";
        HumanMessage humanMessage = new HumanMessage(observation + "\u8bf7\u7ee7\u7eed\u63a8\u7406\u4e0b\u4e00\u6b65\u3002");
        humanMessage.addMetadata("type", "reActObservation");
        return humanMessage;
    }
}

