/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.prompt;

import com.agentsflex.core.llm.functions.Function;
import com.agentsflex.core.llm.functions.Parameter;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.FunctionCall;
import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.message.SystemMessage;
import com.agentsflex.core.message.ToolMessage;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.Maps;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultPromptFormat
implements PromptFormat {
    @Override
    public Object toMessagesJsonObject(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return null;
        }
        ArrayList<Map<String, Object>> messageJsonArray = new ArrayList<Map<String, Object>>(messages.size());
        this.buildMessageJsonArray(messageJsonArray, messages);
        return messageJsonArray;
    }

    protected void buildMessageJsonArray(List<Map<String, Object>> messageJsonArray, List<Message> messages) {
        messages.forEach(message -> {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            if (message instanceof HumanMessage) {
                map.put("role", "user");
            } else if (message instanceof AiMessage) {
                map.put("role", "assistant");
                AiMessage aiMessage = (AiMessage)message;
                List<FunctionCall> calls = aiMessage.getCalls();
                if (calls != null && !calls.isEmpty()) {
                    map.put("content", "");
                    this.buildToolCalls(map, calls);
                    messageJsonArray.add(map);
                    return;
                }
            } else if (message instanceof SystemMessage) {
                map.put("role", "system");
            } else if (message instanceof ToolMessage) {
                map.put("role", "tool");
                map.put("tool_call_id", ((ToolMessage)message).getToolCallId());
            }
            this.buildMessageContent((Message)message, (Map<String, Object>)map);
            messageJsonArray.add(map);
        });
    }

    protected void buildToolCalls(Map<String, Object> map, List<FunctionCall> calls) {
        ArrayList<Maps> toolCalls = new ArrayList<Maps>();
        for (FunctionCall call : calls) {
            Maps toolCall = new Maps();
            toolCall.set("id", call.getId()).set("type", "function").set("function", Maps.of("name", call.getName()).set("arguments", this.buildToolCallsArguments(call.getArgs())));
            toolCalls.add(toolCall);
        }
        map.put("tool_calls", toolCalls);
    }

    protected Object buildToolCallsArguments(Map<String, Object> arguments) {
        return JSON.toJSONString(arguments, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    protected void buildMessageContent(Message message, Map<String, Object> map) {
        map.put("content", message.getMessageContent());
    }

    @Override
    public Object toFunctionsJsonObject(HumanMessage message) {
        if (message == null) {
            return null;
        }
        List<Function> functions = message.getFunctions();
        if (functions == null || functions.isEmpty()) {
            return null;
        }
        ArrayList<Map<String, Object>> functionsJsonArray = new ArrayList<Map<String, Object>>();
        this.buildFunctionJsonArray(functionsJsonArray, functions);
        return functionsJsonArray;
    }

    protected void buildFunctionJsonArray(List<Map<String, Object>> functionsJsonArray, List<Function> functions) {
        for (Function function : functions) {
            HashMap<String, Object> functionRoot = new HashMap<String, Object>();
            functionRoot.put("type", "function");
            HashMap<String, Object> functionObj = new HashMap<String, Object>();
            functionRoot.put("function", functionObj);
            functionObj.put("name", function.getName());
            functionObj.put("description", function.getDescription());
            HashMap<String, Object> parametersObj = new HashMap<String, Object>();
            functionObj.put("parameters", parametersObj);
            parametersObj.put("type", "object");
            HashMap<String, Object> propertiesObj = new HashMap<String, Object>();
            parametersObj.put("properties", propertiesObj);
            DefaultPromptFormat.addParameters(function.getParameters(), propertiesObj, parametersObj);
            functionsJsonArray.add(functionRoot);
        }
    }

    private static void addParameters(Parameter[] parameters, Map<String, Object> propertiesObj, Map<String, Object> parametersObj) {
        ArrayList<String> requiredProperties = new ArrayList<String>();
        for (Parameter parameter : parameters) {
            List<Parameter> children;
            HashMap<String, Object> parameterObj = new HashMap<String, Object>();
            parameterObj.put("type", parameter.getType());
            parameterObj.put("description", parameter.getDescription());
            parameterObj.put("enum", parameter.getEnums());
            if (parameter.isRequired()) {
                requiredProperties.add(parameter.getName());
            }
            if ((children = parameter.getChildren()) != null && !children.isEmpty()) {
                if ("object".equalsIgnoreCase(parameter.getType())) {
                    HashMap<String, Object> childrenObj = new HashMap<String, Object>();
                    parameterObj.put("properties", childrenObj);
                    DefaultPromptFormat.addParameters(children.toArray(new Parameter[0]), childrenObj, parameterObj);
                }
                if ("array".equalsIgnoreCase(parameter.getType())) {
                    HashMap<String, Object> itemsObj = new HashMap<String, Object>();
                    parameterObj.put("items", itemsObj);
                    DefaultPromptFormat.handleArrayItems(children, itemsObj);
                }
            }
            propertiesObj.put(parameter.getName(), parameterObj);
        }
        if (!requiredProperties.isEmpty()) {
            parametersObj.put("required", requiredProperties);
        }
    }

    private static void handleArrayItems(List<Parameter> children, Map<String, Object> itemsObj) {
        if (children.size() == 1 && children.get(0).getName() == null) {
            Parameter firstChild = children.get(0);
            itemsObj.put("type", firstChild.getType());
            itemsObj.put("description", firstChild.getDescription());
            itemsObj.put("enum", firstChild.getEnums());
            List<Parameter> grandchildren = firstChild.getChildren();
            if (grandchildren != null && !grandchildren.isEmpty()) {
                if ("array".equalsIgnoreCase(firstChild.getType())) {
                    HashMap<String, Object> nestedItemsObj = new HashMap<String, Object>();
                    itemsObj.put("items", nestedItemsObj);
                    DefaultPromptFormat.handleArrayItems(grandchildren, nestedItemsObj);
                } else if ("object".equalsIgnoreCase(firstChild.getType())) {
                    HashMap<String, Object> nestedProperties = new HashMap<String, Object>();
                    itemsObj.put("properties", nestedProperties);
                    DefaultPromptFormat.addParameters(grandchildren.toArray(new Parameter[0]), nestedProperties, itemsObj);
                }
            }
        } else {
            HashMap<String, Object> tempProperties = new HashMap<String, Object>();
            DefaultPromptFormat.addParameters(children.toArray(new Parameter[0]), tempProperties, itemsObj);
            if (!tempProperties.isEmpty()) {
                itemsObj.put("type", "object");
                itemsObj.put("properties", tempProperties);
            }
        }
    }
}

