/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.embedding;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.exception.LlmException;
import com.agentsflex.core.store.VectorData;

public interface EmbeddingModel {
    default public VectorData embed(String text) {
        return this.embed(Document.of(text), EmbeddingOptions.DEFAULT);
    }

    default public VectorData embed(Document document) {
        return this.embed(document, EmbeddingOptions.DEFAULT);
    }

    public VectorData embed(Document var1, EmbeddingOptions var2);

    default public int dimensions() {
        VectorData vectorData = this.embed(Document.of("agents-flex"));
        if (vectorData == null) {
            throw new LlmException("Embedding model does not contain vector data, maybe config is not correct.");
        }
        double[] vector = vectorData.getVector();
        if (vector == null || vector.length == 0) {
            throw new LlmException("Embedding model does not contain vector data, maybe config is not correct.");
        }
        return vector.length;
    }
}

