/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.SystemMessage;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.TextPrompt;
import com.agentsflex.core.prompt.template.TextPromptTemplate;
import com.agentsflex.core.util.CollectionUtil;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LlmNode
extends BaseNode {
    protected Llm llm;
    protected ChatOptions chatOptions = ChatOptions.DEFAULT;
    protected String userPrompt;
    protected TextPromptTemplate userPromptTemplate;
    protected String systemPrompt;
    protected TextPromptTemplate systemPromptTemplate;
    protected String outType = "text";

    public LlmNode() {
    }

    public LlmNode(Llm llm, String userPrompt) {
        this.llm = llm;
        this.userPrompt = userPrompt;
        this.userPromptTemplate = StringUtil.hasText(userPrompt) ? TextPromptTemplate.of(userPrompt) : null;
    }

    public Llm getLlm() {
        return this.llm;
    }

    public void setLlm(Llm llm) {
        this.llm = llm;
    }

    public String getUserPrompt() {
        return this.userPrompt;
    }

    public void setUserPrompt(String userPrompt) {
        this.userPrompt = userPrompt;
        this.userPromptTemplate = StringUtil.hasText(userPrompt) ? TextPromptTemplate.of(userPrompt) : null;
    }

    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    public void setSystemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
        this.systemPromptTemplate = StringUtil.hasText(systemPrompt) ? TextPromptTemplate.of(systemPrompt) : null;
    }

    public ChatOptions getChatOptions() {
        return this.chatOptions;
    }

    public void setChatOptions(ChatOptions chatOptions) {
        if (chatOptions == null) {
            chatOptions = ChatOptions.DEFAULT;
        }
        this.chatOptions = chatOptions;
    }

    public String getOutType() {
        return this.outType;
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }

    @Override
    protected Map<String, Object> execute(Chain chain) {
        Map<String, Object> parameterValues = chain.getParameterValues(this);
        if (this.userPromptTemplate == null) {
            return Collections.emptyMap();
        }
        Object userPrompt = this.userPromptTemplate.format((Map)parameterValues);
        if (this.systemPromptTemplate != null) {
            String systemPrompt = this.systemPromptTemplate.formatToString(parameterValues);
            ((TextPrompt)userPrompt).setSystemMessage(SystemMessage.of(systemPrompt));
        }
        AiMessageResponse response = this.llm.chat((Prompt)userPrompt, this.chatOptions);
        chain.output(this, response);
        if (response == null) {
            return Collections.emptyMap();
        }
        if (response.isError()) {
            chain.stopError(response.getErrorMessage());
            return Collections.emptyMap();
        }
        AiMessage aiMessage = response.getMessage();
        if (aiMessage == null) {
            return Collections.emptyMap();
        }
        String responseContent = aiMessage.getContent();
        if (StringUtil.noText(responseContent)) {
            chain.stopError("Can not get response content: " + response.getResponse());
            return Collections.emptyMap();
        }
        responseContent = responseContent.trim();
        if ("json".equalsIgnoreCase(this.outType)) {
            if (this.outputDefs != null) {
                JSONObject jsonObject;
                try {
                    jsonObject = JSON.parseObject((String)LlmNode.unWrapMarkdown(responseContent));
                }
                catch (Exception e) {
                    chain.stopError("Can not parse json: " + response.getResponse() + " " + e.getMessage());
                    return Collections.emptyMap();
                }
                return LlmNode.getExecuteResultMap(this.outputDefs, jsonObject);
            }
            return Collections.emptyMap();
        }
        if (CollectionUtil.noItems(this.outputDefs)) {
            return Maps.of("output", responseContent);
        }
        Parameter parameter = (Parameter)this.outputDefs.get(0);
        return Maps.of(parameter.getName(), responseContent);
    }

    public static String unWrapMarkdown(String markdown) {
        if (markdown.startsWith("```")) {
            int newlineIndex = markdown.indexOf(10);
            markdown = newlineIndex != -1 ? markdown.substring(newlineIndex + 1) : markdown.substring(3);
        }
        if (markdown.endsWith("```")) {
            markdown = markdown.substring(0, markdown.length() - 3);
        }
        return markdown.trim();
    }

    public static Map<String, Object> getExecuteResultMap(List<Parameter> outputDefs, JSONObject data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        outputDefs.forEach(output -> result.put(output.getName(), LlmNode.getOutputDefData(output, data, false)));
        return result;
    }

    private static Object getOutputDefData(Parameter output, JSONObject data, boolean sub) {
        String name = output.getName();
        DataType dataType = output.getDataType();
        switch (dataType) {
            case Array: 
            case Array_Object: {
                JSONArray contentFields;
                if (output.getChildren() == null || output.getChildren().isEmpty()) {
                    return data.get((Object)name);
                }
                ArrayList subResultList = new ArrayList();
                Object dataObj = data.get((Object)name);
                if (dataObj instanceof JSONArray && !(contentFields = (JSONArray)dataObj).isEmpty()) {
                    contentFields.forEach(field -> {
                        if (field instanceof JSONObject) {
                            subResultList.add(LlmNode.getChildrenResult(output.getChildren(), (JSONObject)field, sub));
                        }
                    });
                }
                return subResultList;
            }
            case Object: {
                return output.getChildren() != null && !output.getChildren().isEmpty() ? LlmNode.getChildrenResult(output.getChildren(), sub ? data : (JSONObject)data.get((Object)name), sub) : data.get((Object)name);
            }
            case String: 
            case Number: 
            case Boolean: {
                Object obj = data.get((Object)name);
                return DataType.String == dataType ? (obj instanceof String ? obj : "") : (DataType.Number == dataType ? (obj instanceof Number ? obj : Integer.valueOf(0)) : (obj instanceof Boolean ? obj : Boolean.valueOf(false)));
            }
            case Array_String: 
            case Array_Number: 
            case Array_Boolean: {
                Object arrayObj = data.get((Object)name);
                if (arrayObj instanceof JSONArray) {
                    ((JSONArray)arrayObj).removeIf(o -> LlmNode.arrayRemoveFlag(dataType, o));
                    return arrayObj;
                }
                return Collections.emptyList();
            }
        }
        return "";
    }

    private static boolean arrayRemoveFlag(DataType dataType, Object arrayObj) {
        boolean removeFlag = false;
        if (DataType.Array_String == dataType) {
            if (!(arrayObj instanceof String)) {
                removeFlag = true;
            }
        } else if (DataType.Array_Number == dataType) {
            if (!(arrayObj instanceof Number)) {
                removeFlag = true;
            }
        } else if (!(arrayObj instanceof Boolean)) {
            removeFlag = true;
        }
        return removeFlag;
    }

    private static Map<String, Object> getChildrenResult(List<Parameter> children, JSONObject data, boolean sub) {
        HashMap<String, Object> childrenResult = new HashMap<String, Object>();
        children.forEach(child -> {
            String childName = child.getName();
            Object subData = LlmNode.getOutputDefData(child, data, sub);
            if (subData instanceof JSONObject && child.getChildren() != null && !child.getChildren().isEmpty()) {
                LlmNode.getChildrenResult(child.getChildren(), (JSONObject)subData, true);
            } else {
                childrenResult.put(childName, subData);
            }
        });
        return childrenResult;
    }

    public String toString() {
        return "LlmNode{llm=" + this.llm + ", chatOptions=" + this.chatOptions + ", userPrompt='" + this.userPrompt + '\'' + ", userPromptTemplate=" + this.userPromptTemplate + ", systemPrompt='" + this.systemPrompt + '\'' + ", systemPromptTemplate=" + this.systemPromptTemplate + ", outType='" + this.outType + '\'' + ", description='" + this.description + '\'' + ", parameters=" + this.parameters + ", outputDefs=" + this.outputDefs + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", async=" + this.async + ", inwardEdges=" + this.inwardEdges + ", outwardEdges=" + this.outwardEdges + ", condition=" + this.condition + ", memory=" + this.memory + ", nodeStatus=" + (Object)((Object)this.nodeStatus) + '}';
    }
}

