/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainSuspendException;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.chain.node.BaseNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ConfirmNode
extends BaseNode {
    private String randomUUID = UUID.randomUUID().toString();
    private String message;
    private List<Parameter> confirms;

    public String getRandomUUID() {
        return this.randomUUID;
    }

    public void setRandomUUID(String randomUUID) {
        this.randomUUID = randomUUID;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<Parameter> getConfirms() {
        return this.confirms;
    }

    public void setConfirms(List<Parameter> confirms) {
        if (confirms != null) {
            for (Parameter confirm : confirms) {
                confirm.setRefType(RefType.INPUT);
                confirm.setRequired(true);
                confirm.setName(confirm.getName());
            }
        }
        this.confirms = confirms;
    }

    @Override
    protected Map<String, Object> execute(Chain chain) {
        Map<String, Object> values;
        ArrayList<Parameter> confirmParameters = new ArrayList<Parameter>();
        this.addConfirmParameter(confirmParameters);
        if (this.confirms != null) {
            for (Parameter confirm : this.confirms) {
                Parameter clone = confirm.clone();
                clone.setName(confirm.getName() + "__" + this.randomUUID);
                clone.setRefType(RefType.INPUT);
                confirmParameters.add(clone);
            }
        }
        try {
            values = chain.getParameterValues(this, confirmParameters);
        }
        catch (ChainSuspendException e) {
            chain.setMessage(this.message);
            if (this.confirms != null) {
                ArrayList<Parameter> newParameters = new ArrayList<Parameter>();
                for (Parameter confirm : this.confirms) {
                    Parameter clone = confirm.clone();
                    clone.setName(confirm.getName() + "__" + this.randomUUID);
                    clone.setRefType(RefType.REF);
                    newParameters.add(clone);
                }
                Map<String, Object> parameterValues = chain.getParameterValuesOnly(this, newParameters, null);
                for (Parameter confirmParameter : confirmParameters) {
                    if (confirmParameter.getEnums() != null) continue;
                    Object enumsObject = parameterValues.get(confirmParameter.getName());
                    confirmParameter.setEnumsObject(enumsObject);
                }
            }
            throw e;
        }
        HashMap<String, Object> results = new HashMap<String, Object>(values.size());
        values.forEach((key, value) -> {
            int index = key.lastIndexOf("__");
            if (index >= 0) {
                results.put(key.substring(0, index), value);
            } else {
                results.put((String)key, value);
            }
        });
        return results;
    }

    private void addConfirmParameter(List<Parameter> parameters) {
        Parameter parameter = new Parameter();
        parameter.setRefType(RefType.INPUT);
        parameter.setId("confirm");
        parameter.setName("confirm__" + this.randomUUID);
        parameter.setRequired(true);
        ArrayList<Object> selectionData = new ArrayList<Object>();
        selectionData.add("yes");
        selectionData.add("no");
        parameter.setEnums(selectionData);
        parameter.setContentType("text");
        parameter.setFormType("confirm");
        parameters.add(parameter);
    }
}

