/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.RefType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Parameter
implements Serializable,
Cloneable {
    protected String id;
    protected String name;
    protected String description;
    protected DataType dataType = DataType.String;
    protected String contentType;
    protected String ref;
    protected RefType refType;
    protected String value;
    protected boolean required;
    protected String defaultValue;
    protected List<Parameter> children;
    protected List<Object> enums;
    protected String formType;
    protected String formLabel;
    protected String formPlaceholder;
    protected String formDescription;
    protected String formAttrs;

    public Parameter() {
    }

    public Parameter(String name) {
        this.name = name;
    }

    public Parameter(String name, DataType dataType) {
        this.name = name;
        this.dataType = dataType;
    }

    public Parameter(String name, boolean required) {
        this.name = name;
        this.required = required;
    }

    public Parameter(String name, DataType dataType, boolean required) {
        this.name = name;
        this.dataType = dataType;
        this.required = required;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public RefType getRefType() {
        return this.refType;
    }

    public void setRefType(RefType refType) {
        this.refType = refType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public List<Parameter> getChildren() {
        return this.children;
    }

    public void setChildren(List<Parameter> children) {
        this.children = children;
    }

    public void addChild(Parameter parameter) {
        if (this.children == null) {
            this.children = new ArrayList<Parameter>();
        }
        this.children.add(parameter);
    }

    public void addChildren(Collection<Parameter> parameters) {
        if (this.children == null) {
            this.children = new ArrayList<Parameter>();
        }
        this.children.addAll(parameters);
    }

    public List<Object> getEnums() {
        return this.enums;
    }

    public void setEnums(List<Object> enums) {
        this.enums = enums;
    }

    public void setEnumsObject(Object enumsObject) {
        if (enumsObject == null) {
            this.enums = null;
        } else if (enumsObject instanceof Collection) {
            this.enums = new ArrayList<Object>();
            this.enums.addAll((Collection)enumsObject);
        } else if (enumsObject.getClass().isArray()) {
            this.enums = new ArrayList<Object>();
            this.enums.addAll(Arrays.asList((Object[])enumsObject));
        } else {
            this.enums = new ArrayList<Object>(1);
            this.enums.add(enumsObject);
        }
    }

    public String getFormType() {
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public String getFormLabel() {
        return this.formLabel;
    }

    public void setFormLabel(String formLabel) {
        this.formLabel = formLabel;
    }

    public String getFormPlaceholder() {
        return this.formPlaceholder;
    }

    public void setFormPlaceholder(String formPlaceholder) {
        this.formPlaceholder = formPlaceholder;
    }

    public String getFormDescription() {
        return this.formDescription;
    }

    public void setFormDescription(String formDescription) {
        this.formDescription = formDescription;
    }

    public String getFormAttrs() {
        return this.formAttrs;
    }

    public void setFormAttrs(String formAttrs) {
        this.formAttrs = formAttrs;
    }

    public String toString() {
        return "Parameter{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", dataType=" + (Object)((Object)this.dataType) + ", contentType='" + this.contentType + '\'' + ", ref='" + this.ref + '\'' + ", refType=" + (Object)((Object)this.refType) + ", value='" + this.value + '\'' + ", required=" + this.required + ", defaultValue='" + this.defaultValue + '\'' + ", children=" + this.children + ", enums=" + this.enums + ", formType='" + this.formType + '\'' + ", formLabel='" + this.formLabel + '\'' + ", formPlaceholder='" + this.formPlaceholder + '\'' + ", formDescription='" + this.formDescription + '\'' + ", formAttrs='" + this.formAttrs + '\'' + '}';
    }

    public Parameter clone() {
        try {
            Parameter clone = (Parameter)super.clone();
            if (this.children != null) {
                clone.children = new ArrayList<Parameter>(this.children.size());
                for (Parameter child : this.children) {
                    clone.children.add(child.clone());
                }
            }
            if (this.enums != null) {
                clone.enums = new ArrayList<Object>(this.enums.size());
                clone.enums.addAll(this.enums);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

