/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainEdge;
import com.agentsflex.core.chain.ChainNode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class NodeContext {
    public ChainNode currentNode;
    public ChainNode prevNode;
    public String fromEdgeId;
    private AtomicInteger triggerCount = new AtomicInteger(0);
    private List<String> triggerEdgeIds = new ArrayList<String>();
    private AtomicInteger executeCount = new AtomicInteger(0);
    private List<String> executeEdgeIds = new ArrayList<String>();

    public ChainNode getCurrentNode() {
        return this.currentNode;
    }

    public ChainNode getPrevNode() {
        return this.prevNode;
    }

    public String getFromEdgeId() {
        return this.fromEdgeId;
    }

    public int getTriggerCount() {
        return this.triggerCount.get();
    }

    public List<String> getTriggerEdgeIds() {
        return this.triggerEdgeIds;
    }

    public int getExecuteCount() {
        return this.executeCount.get();
    }

    public List<String> getExecuteEdgeIds() {
        return this.executeEdgeIds;
    }

    public void setCurrentNode(ChainNode currentNode) {
        this.currentNode = currentNode;
    }

    public void setPrevNode(ChainNode prevNode) {
        this.prevNode = prevNode;
    }

    public void setFromEdgeId(String fromEdgeId) {
        this.fromEdgeId = fromEdgeId;
    }

    public void setTriggerCount(AtomicInteger triggerCount) {
        this.triggerCount = triggerCount;
    }

    public void setTriggerEdgeIds(List<String> triggerEdgeIds) {
        this.triggerEdgeIds = triggerEdgeIds;
    }

    public void setExecuteCount(AtomicInteger executeCount) {
        this.executeCount = executeCount;
    }

    public void setExecuteEdgeIds(List<String> executeEdgeIds) {
        this.executeEdgeIds = executeEdgeIds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isUpstreamFullyExecuted() {
        List<ChainEdge> inwardEdges = this.currentNode.getInwardEdges();
        if (inwardEdges == null) return true;
        if (inwardEdges.isEmpty()) {
            return true;
        }
        List shouldBeTriggerIds = inwardEdges.stream().map(ChainEdge::getId).collect(Collectors.toList());
        if (this.triggerEdgeIds.size() < shouldBeTriggerIds.size()) return false;
        if (!shouldBeTriggerIds.parallelStream().allMatch(this.triggerEdgeIds::contains)) return false;
        return true;
    }

    public void recordTrigger(Chain.ExecuteNode executeNode) {
        this.currentNode = executeNode.currentNode;
        this.prevNode = executeNode.prevNode;
        this.fromEdgeId = executeNode.fromEdgeId;
        this.triggerCount.incrementAndGet();
        this.triggerEdgeIds.add(executeNode.fromEdgeId);
    }

    public synchronized void recordExecute(Chain.ExecuteNode executeNode) {
        this.executeCount.incrementAndGet();
        this.executeEdgeIds.add(executeNode.fromEdgeId);
    }
}

