/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ChainNodeValidResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ChainNodeValidResult SUCCESS = new ChainNodeValidResult(true, null, null);
    public static final ChainNodeValidResult FAILURE = new ChainNodeValidResult(false, null, null);
    private final boolean success;
    private final String message;
    private final Map<String, Object> details;

    private ChainNodeValidResult(boolean success, String message, Map<String, Object> details) {
        this.success = success;
        this.message = message;
        this.details = details != null ? Collections.unmodifiableMap(new HashMap<String, Object>(details)) : null;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public static ChainNodeValidResult ok() {
        return SUCCESS;
    }

    public static ChainNodeValidResult ok(String message) {
        return new ChainNodeValidResult(true, message, null);
    }

    public static ChainNodeValidResult ok(String message, Map<String, Object> details) {
        return new ChainNodeValidResult(true, message, details);
    }

    public static ChainNodeValidResult ok(String message, Object ... kvPairs) {
        Map<String, Object> details = ChainNodeValidResult.toMapFromPairs(kvPairs);
        return new ChainNodeValidResult(true, message, details);
    }

    public static ChainNodeValidResult fail() {
        return FAILURE;
    }

    public static ChainNodeValidResult fail(String message) {
        return new ChainNodeValidResult(false, message, null);
    }

    public static ChainNodeValidResult fail(String message, Map<String, Object> details) {
        return new ChainNodeValidResult(false, message, details);
    }

    public static ChainNodeValidResult fail(String message, Object ... kvPairs) {
        Map<String, Object> details = ChainNodeValidResult.toMapFromPairs(kvPairs);
        return new ChainNodeValidResult(false, message, details);
    }

    public static ChainNodeValidResult failOnField(String field, String reason) {
        Map<String, Object> details = Collections.singletonMap("fieldError", field + ": " + reason);
        return ChainNodeValidResult.fail(reason, details);
    }

    public static ChainNodeValidResult require(boolean condition, String messageIfFail) {
        return condition ? ChainNodeValidResult.ok() : ChainNodeValidResult.fail(messageIfFail);
    }

    private static Map<String, Object> toMapFromPairs(Object ... kvPairs) {
        if (kvPairs == null || kvPairs.length == 0) {
            return null;
        }
        if (kvPairs.length % 2 != 0) {
            throw new IllegalArgumentException("kvPairs must be even-sized: key1, value1, key2, value2...");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < kvPairs.length; i += 2) {
            Object key = kvPairs[i];
            Object value = kvPairs[i + 1];
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Key must be a String, but got: " + key);
            }
            map.put((String)key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChainNodeValidResult)) {
            return false;
        }
        ChainNodeValidResult that = (ChainNodeValidResult)o;
        return this.success == that.success && Objects.equals(this.message, that.message) && Objects.equals(this.details, that.details);
    }

    public int hashCode() {
        return Objects.hash(this.success, this.message, this.details);
    }

    public String toString() {
        return "ChainNodeValidResult{success=" + this.success + ", message='" + this.message + '\'' + ", details=" + this.details + '}';
    }
}

