/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import com.agentsflex.core.chain.ChainContext;
import com.agentsflex.core.chain.ChainEdge;
import com.agentsflex.core.chain.ChainEvent;
import com.agentsflex.core.chain.ChainException;
import com.agentsflex.core.chain.ChainHolder;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.ChainNodeStatus;
import com.agentsflex.core.chain.ChainNodeValidResult;
import com.agentsflex.core.chain.ChainStatus;
import com.agentsflex.core.chain.ChainSuspendException;
import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.EdgeCondition;
import com.agentsflex.core.chain.NodeCondition;
import com.agentsflex.core.chain.NodeContext;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.chain.event.ChainEndEvent;
import com.agentsflex.core.chain.event.ChainResumeEvent;
import com.agentsflex.core.chain.event.ChainStartEvent;
import com.agentsflex.core.chain.event.ChainStatusChangeEvent;
import com.agentsflex.core.chain.event.NodeEndEvent;
import com.agentsflex.core.chain.event.NodeStartEvent;
import com.agentsflex.core.chain.listener.ChainErrorListener;
import com.agentsflex.core.chain.listener.ChainEventListener;
import com.agentsflex.core.chain.listener.ChainOutputListener;
import com.agentsflex.core.chain.listener.ChainSuspendListener;
import com.agentsflex.core.chain.listener.NodeErrorListener;
import com.agentsflex.core.prompt.template.TextPromptTemplate;
import com.agentsflex.core.util.CollectionUtil;
import com.agentsflex.core.util.MapUtil;
import com.agentsflex.core.util.NamedThreadPools;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chain
extends ChainNode {
    private static final Logger log = LoggerFactory.getLogger(Chain.class);
    protected List<ChainNode> nodes;
    protected List<ChainEdge> edges;
    protected Map<String, Object> executeResult = null;
    protected Map<Class<?>, List<ChainEventListener>> eventListeners = new HashMap(0);
    protected List<ChainOutputListener> outputListeners = new ArrayList<ChainOutputListener>();
    protected List<ChainErrorListener> chainErrorListeners = new ArrayList<ChainErrorListener>();
    protected List<NodeErrorListener> nodeErrorListeners = new ArrayList<NodeErrorListener>();
    protected List<ChainSuspendListener> suspendListeners = new ArrayList<ChainSuspendListener>();
    protected ExecutorService asyncNodeExecutors = NamedThreadPools.newFixedThreadPool("chain-executor");
    protected Phaser phaser = new Phaser(1);
    protected Map<String, NodeContext> nodeContexts = new ConcurrentHashMap<String, NodeContext>();
    protected Map<String, ChainNode> suspendNodes = new ConcurrentHashMap<String, ChainNode>();
    protected List<Parameter> suspendForParameters;
    protected ChainStatus status = ChainStatus.READY;
    protected Exception exception;
    protected String message;

    public Chain() {
        this.id = UUID.randomUUID().toString();
    }

    public Chain(ChainHolder holder) {
        this.id = holder.getId();
        this.name = holder.getName();
        this.description = holder.getDescription();
        this.nodes = holder.getNodes();
        this.edges = holder.getEdges();
        this.executeResult = holder.getExecuteResult();
        this.nodeContexts = holder.getNodeContexts();
        this.suspendNodes = holder.getSuspendNodes();
        this.suspendForParameters = holder.getSuspendForParameters();
        this.status = holder.getStatus();
        this.message = holder.getMessage();
    }

    public Map<Class<?>, List<ChainEventListener>> getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(Map<Class<?>, List<ChainEventListener>> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public synchronized void addEventListener(Class<? extends ChainEvent> eventClass, ChainEventListener listener) {
        List chainEventListeners = this.eventListeners.computeIfAbsent(eventClass, k -> new ArrayList());
        chainEventListeners.add(listener);
    }

    public synchronized void addEventListener(ChainEventListener listener) {
        List chainEventListeners = this.eventListeners.computeIfAbsent(ChainEvent.class, k -> new ArrayList());
        chainEventListeners.add(listener);
    }

    public synchronized void removeEventListener(ChainEventListener listener) {
        for (List<ChainEventListener> list : this.eventListeners.values()) {
            list.removeIf(item -> item == listener);
        }
    }

    public synchronized void removeEventListener(Class<? extends ChainEvent> eventClass, ChainEventListener listener) {
        List<ChainEventListener> list = this.eventListeners.get(eventClass);
        if (list != null && !list.isEmpty()) {
            list.removeIf(item -> item == listener);
        }
    }

    public synchronized void addErrorListener(ChainErrorListener listener) {
        this.chainErrorListeners.add(listener);
    }

    public synchronized void removeErrorListener(ChainErrorListener listener) {
        this.chainErrorListeners.remove(listener);
    }

    public synchronized void addNodeErrorListener(NodeErrorListener listener) {
        this.nodeErrorListeners.add(listener);
    }

    public synchronized void removeNodeErrorListener(NodeErrorListener listener) {
        this.nodeErrorListeners.remove(listener);
    }

    public synchronized void addSuspendListener(ChainSuspendListener listener) {
        this.suspendListeners.add(listener);
    }

    public synchronized void removeSuspendListener(ChainSuspendListener listener) {
        this.suspendListeners.remove(listener);
    }

    public List<ChainOutputListener> getOutputListeners() {
        return this.outputListeners;
    }

    public void setOutputListeners(List<ChainOutputListener> outputListeners) {
        this.outputListeners = outputListeners;
    }

    public void addOutputListener(ChainOutputListener outputListener) {
        if (this.outputListeners == null) {
            this.outputListeners = new ArrayList<ChainOutputListener>();
        }
        this.outputListeners.add(outputListener);
    }

    public List<ChainNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<ChainNode> chainNodes) {
        this.nodes = chainNodes;
    }

    public void addNode(ChainNode chainNode) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<ChainNode>();
        }
        if (chainNode instanceof ChainEventListener) {
            this.addEventListener((ChainEventListener)((Object)chainNode));
        }
        if (chainNode.getId() == null) {
            chainNode.setId(UUID.randomUUID().toString());
        }
        this.nodes.add(chainNode);
    }

    public ChainStatus getStatus() {
        return this.status;
    }

    public void setStatus(ChainStatus status) {
        this.status = status;
    }

    public void setStatusAndNotifyEvent(ChainStatus status) {
        ChainStatus before = this.status;
        this.status = status;
        if (before != status) {
            this.notifyEvent(new ChainStatusChangeEvent(this, this.status, before));
        }
    }

    public void notifyEvent(ChainEvent event) {
        for (Map.Entry<Class<?>, List<ChainEventListener>> entry : this.eventListeners.entrySet()) {
            if (!entry.getKey().isInstance(event)) continue;
            for (ChainEventListener chainEventListener : entry.getValue()) {
                chainEventListener.onEvent(event, this);
            }
        }
    }

    public Map<String, Object> getExecuteResult() {
        return this.executeResult;
    }

    public void setExecuteResult(Map<String, Object> executeResult) {
        this.executeResult = executeResult;
    }

    public List<ChainErrorListener> getChainErrorListeners() {
        return this.chainErrorListeners;
    }

    public void setChainErrorListeners(List<ChainErrorListener> chainErrorListeners) {
        this.chainErrorListeners = chainErrorListeners;
    }

    public List<NodeErrorListener> getNodeErrorListeners() {
        return this.nodeErrorListeners;
    }

    public void setNodeErrorListeners(List<NodeErrorListener> nodeErrorListeners) {
        this.nodeErrorListeners = nodeErrorListeners;
    }

    public List<ChainSuspendListener> getSuspendListeners() {
        return this.suspendListeners;
    }

    public void setSuspendListeners(List<ChainSuspendListener> suspendListeners) {
        this.suspendListeners = suspendListeners;
    }

    public Map<String, NodeContext> getNodeContexts() {
        return this.nodeContexts;
    }

    public void setNodeContexts(Map<String, NodeContext> nodeContexts) {
        this.nodeContexts = nodeContexts;
    }

    public Map<String, ChainNode> getSuspendNodes() {
        return this.suspendNodes;
    }

    public void setSuspendNodes(Map<String, ChainNode> suspendNodes) {
        this.suspendNodes = suspendNodes;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Phaser getPhaser() {
        return this.phaser;
    }

    public void setPhaser(Phaser phaser) {
        this.phaser = phaser;
    }

    public void set(String key, Object value) {
        this.memory.put(key, value);
    }

    public Object get(String key) {
        if (StringUtil.noText(key)) {
            return null;
        }
        Object result = this.memory.get(key);
        if (result != null) {
            return result;
        }
        List<String> parts = Arrays.asList(key.split("\\."));
        if (parts.isEmpty()) {
            return null;
        }
        int matchedLevels = 0;
        for (int i = parts.size(); i > 0; --i) {
            String tryKey = String.join((CharSequence)".", parts.subList(0, i));
            Object tempResult = this.memory.get(tryKey);
            if (tempResult == null) continue;
            result = tempResult;
            matchedLevels = i;
            break;
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Collection) {
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object item : (Collection)result) {
                results.add(Chain.getResult(parts, matchedLevels, item));
            }
            return results;
        }
        return Chain.getResult(parts, matchedLevels, result);
    }

    private static Object getResult(List<String> parts, int matchedLevels, Object result) {
        List<String> remainingParts = parts.subList(matchedLevels, parts.size());
        String jsonPath = "$." + String.join((CharSequence)".", remainingParts);
        try {
            return JSONPath.eval((Object)result, (String)jsonPath);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected Map<String, Object> execute(Chain parent) {
        return this.executeForResult(parent.getMemory().getAll());
    }

    public void execute(Map<String, Object> variables) {
        this.runInLifeCycle(variables, new ChainStartEvent(this, variables), this::executeInternal);
    }

    public Map<String, Object> executeForResult(Map<String, Object> variables) {
        return this.executeForResult(variables, false);
    }

    public Map<String, Object> executeForResult(Map<String, Object> variables, boolean ignoreError) {
        if (this.status == ChainStatus.SUSPEND) {
            this.resume(variables);
        } else {
            this.runInLifeCycle(variables, new ChainStartEvent(this, variables), this::executeInternal);
        }
        if (!ignoreError) {
            if (this.status == ChainStatus.FINISHED_ABNORMAL) {
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    throw new ChainException(this.exception);
                }
                if (this.message == null) {
                    this.message = "Chain execute error";
                }
                throw new ChainException(this.message);
            }
            if (this.status == ChainStatus.SUSPEND && this.exception != null) {
                throw (ChainSuspendException)this.exception;
            }
        }
        return this.executeResult;
    }

    @Override
    public List<Parameter> getParameters() {
        List<ChainNode> startNodes = this.getStartNodes();
        if (startNodes == null || startNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (ChainNode node : startNodes) {
            List<Parameter> nodeParameters = node.getParameters();
            if (nodeParameters == null) continue;
            parameters.addAll(nodeParameters);
        }
        return parameters;
    }

    public Map<String, Object> getParameterValues(ChainNode node) {
        return this.getParameterValues(node, node.getParameters());
    }

    public Map<String, Object> getParameterValues(ChainNode node, List<? extends Parameter> parameters) {
        return this.getParameterValues(node, parameters, null);
    }

    public Map<String, Object> getParameterValues(ChainNode node, List<? extends Parameter> parameters, Map<String, Object> formatArgs) {
        return this.getParameterValues(node, parameters, formatArgs, false);
    }

    private boolean isNullOrBlank(Object value) {
        return value == null || value instanceof String && StringUtil.noText((String)value);
    }

    public Map<String, Object> getParameterValuesOnly(ChainNode node, List<? extends Parameter> parameters, Map<String, Object> formatArg) {
        return this.getParameterValues(node, parameters, formatArg, true);
    }

    public Map<String, Object> getParameterValues(ChainNode node, List<? extends Parameter> parameters, Map<String, Object> formatArgs, boolean getValueOnly) {
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
        ArrayList<Parameter> suspendParameters = null;
        for (Parameter parameter : parameters) {
            RefType refType = parameter.getRefType();
            Object value = refType == RefType.FIXED ? (formatArgs != null && !formatArgs.isEmpty() ? TextPromptTemplate.of(parameter.getValue()).formatToString(formatArgs) : parameter.getValue()) : (refType == RefType.REF ? this.get(parameter.getRef()) : this.get(parameter.getName()));
            if (value == null && parameter.getDefaultValue() != null) {
                value = parameter.getDefaultValue();
            }
            if (refType == RefType.INPUT && this.isNullOrBlank(value) && !getValueOnly && parameter.isRequired()) {
                if (suspendParameters == null) {
                    suspendParameters = new ArrayList<Parameter>();
                }
                suspendParameters.add(parameter);
                continue;
            }
            if (parameter.isRequired() && this.isNullOrBlank(value) && !getValueOnly) {
                throw new ChainException(node.getName() + " Missing required parameter:" + parameter.getName());
            }
            if (value instanceof String) {
                value = ((String)value).trim();
                if (parameter.getDataType() == DataType.Boolean) {
                    value = "true".equalsIgnoreCase((String)value) || "1".equalsIgnoreCase((String)value);
                } else if (parameter.getDataType() == DataType.Number) {
                    value = Long.parseLong((String)value);
                } else if (parameter.getDataType() == DataType.Array) {
                    value = JSON.parseArray((String)((String)value));
                }
            }
            variables.put(parameter.getName(), value);
        }
        if (suspendParameters != null && !suspendParameters.isEmpty()) {
            this.setSuspendForParameters((List<Parameter>)suspendParameters);
            this.suspend(node);
            String missingParams = suspendParameters.stream().map(Parameter::getName).collect(Collectors.joining("', '", "'", "'"));
            String string = String.format("Node '%s' (type: %s) is suspended. Waiting for input parameters: %s.", StringUtil.getFirstWithText(node.getName(), node.getId()), node.getClass().getSimpleName(), missingParams);
            throw new ChainSuspendException(string);
        }
        return variables;
    }

    public NodeContext getNodeContext(String nodeId) {
        return MapUtil.computeIfAbsent(this.nodeContexts, nodeId, k -> new NodeContext());
    }

    protected void executeInternal() {
        List<ChainNode> currentNodes = this.getStartNodes();
        if (currentNodes == null || currentNodes.isEmpty()) {
            return;
        }
        ArrayList<ExecuteNode> executeNodes = new ArrayList<ExecuteNode>();
        for (ChainNode currentNode : currentNodes) {
            executeNodes.add(new ExecuteNode(currentNode, null, ""));
        }
        this.doExecuteNodes(executeNodes);
    }

    protected void doExecuteNodes(List<ExecuteNode> executeNodes) {
        for (ExecuteNode executeNode : executeNodes) {
            ChainNode currentNode = executeNode.currentNode;
            if (currentNode.isAsync()) {
                this.phaser.register();
                this.asyncNodeExecutors.execute(() -> {
                    try {
                        this.doExecuteNode(executeNode);
                    }
                    finally {
                        this.phaser.arriveAndDeregister();
                    }
                });
                continue;
            }
            this.doExecuteNode(executeNode);
        }
    }

    public Map<String, Object> getNodeExecuteResult(String nodeId) {
        Map<String, Object> all = this.getMemory().getAll();
        HashMap<String, Object> result = new HashMap<String, Object>();
        all.forEach((k, v) -> {
            if (k.startsWith(nodeId)) {
                String newKey = k.substring(nodeId.length() + 1);
                result.put(newKey, v);
            }
        });
        return result;
    }

    private synchronized void addComputeCost(long computeCost) {
        this.computeCost += computeCost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecuteNode(ExecuteNode executeNode) {
        if (this.getStatus() != ChainStatus.RUNNING) {
            return;
        }
        ChainNode currentNode = executeNode.currentNode;
        NodeContext nodeContext = this.getNodeContext(currentNode.id);
        Map<String, Object> executeResult = null;
        try {
            this.onNodeExecuteBefore(nodeContext);
            if (this.shouldSkipCurrentNode(executeNode, nodeContext, currentNode)) {
                return;
            }
            try {
                ChainContext.setNode(currentNode);
                this.notifyEvent(new NodeStartEvent(this, currentNode));
                if (this.getStatus() != ChainStatus.RUNNING) {
                    return;
                }
                currentNode.setNodeStatus(ChainNodeStatus.RUNNING);
                this.onNodeExecuteStart(nodeContext);
                try {
                    this.suspendNodes.remove(currentNode.getId());
                    executeResult = currentNode.execute(this);
                    this.addComputeCost(currentNode.getComputeCost());
                }
                finally {
                    nodeContext.recordExecute(executeNode);
                    this.executeResult = executeResult;
                }
            }
            catch (Throwable error) {
                currentNode.setNodeStatus(ChainNodeStatus.ERROR);
                this.notifyNodeError(error, currentNode, executeResult);
                throw error;
            }
            finally {
                currentNode.setNodeStatusFinished();
                this.onNodeExecuteEnd(nodeContext);
                ChainContext.clearNode();
                this.notifyEvent(new NodeEndEvent(this, currentNode, executeResult));
            }
            if (executeResult != null && !executeResult.isEmpty()) {
                executeResult.forEach((s, o) -> this.memory.put(currentNode.id + "." + s, o));
            }
        }
        finally {
            this.onNodeExecuteAfter(nodeContext);
        }
        if (this.getStatus() != ChainStatus.RUNNING) {
            return;
        }
        if (!currentNode.isLoopEnable()) {
            this.doExecuteNextNodes(currentNode, executeResult);
            return;
        }
        if (currentNode.getMaxLoopCount() > 0 && nodeContext.getExecuteCount() >= currentNode.getMaxLoopCount()) {
            this.doExecuteNextNodes(currentNode, executeResult);
            return;
        }
        NodeCondition breakCondition = currentNode.getLoopBreakCondition();
        if (breakCondition != null && breakCondition.check(this, nodeContext, executeResult)) {
            this.doExecuteNextNodes(currentNode, executeResult);
            return;
        }
        long loopIntervalMs = currentNode.getLoopIntervalMs();
        if (loopIntervalMs > 0L) {
            try {
                Thread.sleep(loopIntervalMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.doExecuteNode(executeNode);
    }

    private synchronized boolean shouldSkipCurrentNode(ExecuteNode executeNode, NodeContext nodeContext, ChainNode currentNode) {
        nodeContext.recordTrigger(executeNode);
        NodeCondition condition = currentNode.getCondition();
        if (condition == null) {
            return false;
        }
        ChainNode prevNode = executeNode.prevNode;
        Map<String, Object> prevNodeExecuteResult = prevNode != null ? this.getNodeExecuteResult(prevNode.id) : Collections.emptyMap();
        return !condition.check(this, nodeContext, prevNodeExecuteResult);
    }

    private void doExecuteNextNodes(ChainNode currentNode, Map<String, Object> executeResult) {
        List<ChainEdge> outwardEdges = currentNode.getOutwardEdges();
        if (CollectionUtil.hasItems(outwardEdges)) {
            ArrayList<ExecuteNode> nextExecuteNodes = new ArrayList<ExecuteNode>(outwardEdges.size());
            for (ChainEdge chainEdge : outwardEdges) {
                EdgeCondition condition;
                ChainNode nextNode = this.getNodeById(chainEdge.getTarget());
                if (nextNode == null || (condition = chainEdge.getCondition()) != null && !condition.check(this, chainEdge, executeResult)) continue;
                nextExecuteNodes.add(new ExecuteNode(nextNode, currentNode, chainEdge.getId()));
            }
            this.doExecuteNodes(nextExecuteNodes);
        }
    }

    protected void onNodeExecuteAfter(NodeContext nodeContext) {
    }

    protected void onNodeExecuteEnd(NodeContext nodeContext) {
    }

    protected void onNodeExecuteStart(NodeContext nodeContext) {
    }

    protected void onNodeExecuteBefore(NodeContext nodeContext) {
    }

    private List<ChainNode> getStartNodes() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return null;
        }
        if (!this.suspendNodes.isEmpty()) {
            return new ArrayList<ChainNode>(this.suspendNodes.values());
        }
        ArrayList<ChainNode> nodes = new ArrayList<ChainNode>();
        for (ChainNode node : this.nodes) {
            if (!CollectionUtil.noItems(node.getInwardEdges())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private ChainNode getNodeById(String id) {
        if (id == null || StringUtil.noText(id)) {
            return null;
        }
        for (ChainNode node : this.nodes) {
            if (!id.equals(node.getId())) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInLifeCycle(Map<String, Object> variables, ChainEvent startEvent, Runnable runnable) {
        if (variables != null) {
            this.memory.putAll(variables);
        }
        try {
            ChainContext.setChain(this);
            this.notifyEvent(startEvent);
            try {
                this.setStatusAndNotifyEvent(ChainStatus.RUNNING);
                runnable.run();
            }
            catch (ChainSuspendException cse) {
                this.notifySuspend();
                this.exception = cse;
            }
            catch (Exception e) {
                this.exception = e;
                this.setStatusAndNotifyEvent(ChainStatus.ERROR);
                this.notifyError(e);
            }
            this.phaser.arriveAndAwaitAdvance();
            if (this.status == ChainStatus.RUNNING) {
                this.setStatusAndNotifyEvent(ChainStatus.FINISHED_NORMAL);
            } else if (this.status == ChainStatus.ERROR) {
                this.setStatusAndNotifyEvent(ChainStatus.FINISHED_ABNORMAL);
            }
        }
        finally {
            ChainContext.clearChain();
            this.notifyEvent(new ChainEndEvent(this));
        }
    }

    private void notifyOutput(ChainNode node, Object response) {
        for (ChainOutputListener inputListener : this.outputListeners) {
            inputListener.onOutput(this, node, response);
        }
    }

    private void notifySuspend() {
        for (ChainSuspendListener suspendListener : this.suspendListeners) {
            suspendListener.onSuspend(this);
        }
    }

    private void notifyError(Throwable error) {
        for (ChainErrorListener errorListener : this.chainErrorListeners) {
            errorListener.onError(error, this);
        }
    }

    private void notifyNodeError(Throwable error, ChainNode node, Map<String, Object> executeResult) {
        for (NodeErrorListener errorListener : this.nodeErrorListeners) {
            errorListener.onError(error, node, executeResult, this);
        }
    }

    public void stopNormal(String message) {
        this.message = message;
        this.setStatusAndNotifyEvent(ChainStatus.FINISHED_NORMAL);
    }

    public void stopError(String message) {
        this.message = message;
        this.setStatusAndNotifyEvent(ChainStatus.FINISHED_ABNORMAL);
    }

    public void output(ChainNode node, Object response) {
        this.notifyOutput(node, response);
    }

    public String getMessage() {
        return this.message;
    }

    public List<ChainEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<ChainEdge> edges) {
        this.edges = edges;
    }

    public void addEdge(ChainEdge edge) {
        if (this.edges == null) {
            this.edges = new ArrayList<ChainEdge>();
        }
        this.edges.add(edge);
        boolean findSource = false;
        boolean findTarget = false;
        for (ChainNode node : this.nodes) {
            if (node.getId().equals(edge.getSource())) {
                node.addOutwardEdge(edge);
                findSource = true;
            } else if (node.getId().equals(edge.getTarget())) {
                node.addInwardEdge(edge);
                findTarget = true;
            }
            if (!findSource || !findTarget) continue;
            break;
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ExecutorService getAsyncNodeExecutors() {
        return this.asyncNodeExecutors;
    }

    public void setAsyncNodeExecutors(ExecutorService asyncNodeExecutors) {
        this.asyncNodeExecutors = asyncNodeExecutors;
    }

    public List<Parameter> getSuspendForParameters() {
        return this.suspendForParameters;
    }

    public void setSuspendForParameters(List<Parameter> suspendForParameters) {
        this.suspendForParameters = suspendForParameters;
    }

    public synchronized void addSuspendForParameter(Parameter suspendForParameter) {
        if (this.suspendForParameters == null) {
            this.suspendForParameters = new ArrayList<Parameter>();
        }
        this.suspendForParameters.add(suspendForParameter);
    }

    public synchronized void suspend(ChainNode node) {
        try {
            this.suspendNodes.putIfAbsent(node.getId(), node);
        }
        finally {
            this.setStatusAndNotifyEvent(ChainStatus.SUSPEND);
        }
    }

    public void resume(Map<String, Object> variables) {
        this.runInLifeCycle(variables, new ChainResumeEvent(this, variables), this::executeInternal);
    }

    public void reset() {
        this.memory.clear();
        this.nodeStatus = ChainNodeStatus.READY;
        this.status = ChainStatus.READY;
        this.executeResult = null;
        this.message = null;
        this.exception = null;
        this.nodeContexts.clear();
        this.computeCost = 0L;
        if (this.suspendNodes != null) {
            this.suspendNodes.clear();
        }
        if (this.suspendForParameters != null) {
            this.suspendForParameters.clear();
        }
        this.asyncNodeExecutors = NamedThreadPools.newFixedThreadPool("chain-executor");
        this.phaser = new Phaser(1);
    }

    public String toJSON() {
        return ChainHolder.fromChain(this).toJSON();
    }

    public static Chain fromJSON(String jsonString) {
        return ChainHolder.fromJSON(jsonString).toChain();
    }

    @Override
    public ChainNodeValidResult validate() throws Exception {
        if (this.validator != null) {
            return this.validator.validate(this);
        }
        if (this.nodes == null || this.nodes.isEmpty()) {
            return ChainNodeValidResult.fail("Chain nodes can not be empty.");
        }
        HashMap<String, Object> details = new HashMap<String, Object>();
        for (ChainNode node : this.nodes) {
            ChainNodeValidResult nodeResult = node.validate();
            if (nodeResult == null || nodeResult.isSuccess()) continue;
            details.put(node.getId(), nodeResult);
        }
        return details.isEmpty() ? ChainNodeValidResult.ok() : ChainNodeValidResult.fail("", details);
    }

    public String toString() {
        return "Chain{nodes=" + this.nodes + ", edges=" + this.edges + ", executeResult=" + this.executeResult + ", eventListeners=" + this.eventListeners + ", outputListeners=" + this.outputListeners + ", chainErrorListeners=" + this.chainErrorListeners + ", nodeErrorListeners=" + this.nodeErrorListeners + ", suspendListeners=" + this.suspendListeners + ", asyncNodeExecutors=" + this.asyncNodeExecutors + ", phaser=" + this.phaser + ", nodeContexts=" + this.nodeContexts + ", suspendNodes=" + this.suspendNodes + ", suspendForParameters=" + this.suspendForParameters + ", status=" + (Object)((Object)this.status) + ", exception=" + this.exception + ", message='" + this.message + '\'' + '}';
    }

    public static class ExecuteNode {
        final ChainNode currentNode;
        final ChainNode prevNode;
        final String fromEdgeId;

        public ExecuteNode(ChainNode currentNode, ChainNode prevNode, String fromEdgeId) {
            this.currentNode = currentNode;
            this.prevNode = prevNode;
            this.fromEdgeId = fromEdgeId;
        }
    }
}

