/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.chain.node;

import com.agentsflex.chain.node.GraalToFastjsonUtils;
import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.node.CodeNode;
import com.agentsflex.core.util.graalvm.JsInteropUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;

public class JsExecNode
extends CodeNode {
    private static final Context.Builder CONTEXT_BUILDER = Context.newBuilder((String[])new String[]{"js"}).option("engine.WarnInterpreterOnly", "false").allowHostAccess(HostAccess.ALL).allowHostClassLookup(className -> false).option("js.ecmascript-version", "2021");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Object> executeCode(String code, Chain chain) {
        try (Context context = CONTEXT_BUILDER.build();){
            Value bindings = context.getBindings("js");
            Map all = chain.getMemory().getAll();
            all.forEach((key, value) -> {
                if (!key.contains(".")) {
                    bindings.putMember(key, (Object)JsInteropUtils.wrapJavaValueForJS((Context)context, (Object)value));
                }
            });
            Map parameterValues = chain.getParameterValues((ChainNode)this);
            if (parameterValues != null) {
                for (Map.Entry entry : parameterValues.entrySet()) {
                    bindings.putMember((String)entry.getKey(), (Object)JsInteropUtils.wrapJavaValueForJS((Context)context, entry.getValue()));
                }
            }
            bindings.putMember("_chain", (Object)chain);
            bindings.putMember("_context", (Object)chain.getNodeContext(this.id));
            context.eval("js", (CharSequence)"var _result = {};");
            bindings.putMember("_chain", (Object)chain);
            bindings.putMember("_context", (Object)chain.getNodeContext(this.id));
            context.eval("js", (CharSequence)code);
            Value resultValue = bindings.getMember("_result");
            JSONObject jSONObject = GraalToFastjsonUtils.toJSONObject(resultValue);
            return jSONObject;
        }
        catch (Exception e) {
            throw new RuntimeException("Polyglot JS \u811a\u672c\u6267\u884c\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "JsExecNode{inwardEdges=" + this.inwardEdges + ", code='" + this.code + '\'' + ", description='" + this.description + '\'' + ", parameters=" + this.parameters + ", outputDefs=" + this.outputDefs + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", async=" + this.async + ", outwardEdges=" + this.outwardEdges + ", condition=" + this.condition + ", memory=" + this.memory + ", nodeStatus=" + this.nodeStatus + '}';
    }
}

