/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.chain.node;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.Value;

public class GraalToFastjsonUtils {
    public static Object toFastJsonValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Value) {
            Value value = (Value)obj;
            if (value.isNull()) {
                return null;
            }
            if (value.isBoolean()) {
                return value.as(Boolean.class);
            }
            if (value.isNumber()) {
                if (value.fitsInLong()) {
                    return value.as(Long.class);
                }
                if (value.fitsInDouble()) {
                    return value.as(Double.class);
                }
                return value.toString();
            }
            if (value.isString()) {
                return value.as(String.class);
            }
            if (value.hasArrayElements()) {
                long size = value.getArraySize();
                JSONArray array = new JSONArray();
                for (long i = 0L; i < size; ++i) {
                    array.add(GraalToFastjsonUtils.toFastJsonValue(value.getArrayElement(i)));
                }
                return array;
            }
            if (value.hasMembers()) {
                JSONObject object = new JSONObject();
                Set keys = value.getMemberKeys();
                for (String key : keys) {
                    Value member = value.getMember(key);
                    if (member.canExecute()) continue;
                    object.put(key, GraalToFastjsonUtils.toFastJsonValue(member));
                }
                return object;
            }
            return value.toString();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry entry : map.entrySet()) {
                String key = Objects.toString(entry.getKey(), "null");
                Object convertedValue = GraalToFastjsonUtils.toFastJsonValue(entry.getValue());
                jsonObject.put(key, convertedValue);
            }
            return jsonObject;
        }
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            JSONArray array = new JSONArray();
            for (Object item : coll) {
                array.add(GraalToFastjsonUtils.toFastJsonValue(item));
            }
            return array;
        }
        if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            JSONArray array = new JSONArray();
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(obj, i);
                array.add(GraalToFastjsonUtils.toFastJsonValue(item));
            }
            return array;
        }
        if (obj instanceof String || obj instanceof Boolean || obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double) {
            return obj;
        }
        return obj.toString();
    }

    public static JSONObject toJSONObject(Object obj) {
        Object result = GraalToFastjsonUtils.toFastJsonValue(obj);
        if (result instanceof JSONObject) {
            return (JSONObject)result;
        }
        if (result instanceof Map) {
            return new JSONObject((Map)result);
        }
        return new JSONObject().fluentPut("value", result);
    }
}

