/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TransportUtils {
    public static SSLContext sslContextFromHttpCaCrt(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            SSLContext sSLContext = TransportUtils.sslContextFromHttpCaCrt(in);
            return sSLContext;
        }
    }

    public static SSLContext sslContextFromHttpCaCrt(InputStream in) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate certificate = cf.generateCertificate(in);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("elasticsearch-ca", certificate);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLContext sslContextFromCaFingerprint(String fingerPrint) {
        fingerPrint = fingerPrint.replace(":", "");
        int len = fingerPrint.length();
        final byte[] fpBytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            fpBytes[i / 2] = (byte)((Character.digit(fingerPrint.charAt(i), 16) << 4) + Character.digit(fingerPrint.charAt(i + 1), 16));
        }
        try {
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    throw new CertificateException("This is a client-side only trust manager");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    byte[] bytes;
                    X509Certificate anchor = chain[chain.length - 1];
                    try {
                        MessageDigest md = MessageDigest.getInstance("SHA-256");
                        md.update(anchor.getEncoded());
                        bytes = md.digest();
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                    if (Arrays.equals(fpBytes, bytes)) {
                        return;
                    }
                    throw new CertificateException("Untrusted certificate: " + String.valueOf(anchor.getSubjectX500Principal()));
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new X509TrustManager[]{tm}, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLContext insecureSSLContext() {
        SSLContext result;
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        try {
            result = SSLContext.getInstance("SSL");
            result.init(null, new X509TrustManager[]{trustManager}, null);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

