/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.get_mapping.IndexMappingRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetMappingResponse
implements JsonpSerializable {
    private final Map<String, IndexMappingRecord> mappings;
    public static final JsonpDeserializer<GetMappingResponse> _DESERIALIZER = GetMappingResponse.createGetMappingResponseDeserializer();

    private GetMappingResponse(Builder builder) {
        this.mappings = ApiTypeHelper.unmodifiableRequired(builder.mappings, (Object)this, "mappings");
    }

    public static GetMappingResponse of(Function<Builder, ObjectBuilder<GetMappingResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, IndexMappingRecord> mappings() {
        return this.mappings;
    }

    @Nullable
    public final IndexMappingRecord get(String key) {
        return this.mappings.get(key);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        for (Map.Entry<String, IndexMappingRecord> item0 : this.mappings.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static JsonpDeserializer<GetMappingResponse> createGetMappingResponseDeserializer() {
        JsonpDeserializer<Map<String, IndexMappingRecord>> valueDeserializer = JsonpDeserializer.stringMapDeserializer(IndexMappingRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().mappings((Map)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetMappingResponse> {
        private Map<String, IndexMappingRecord> mappings = new HashMap<String, IndexMappingRecord>();

        public final Builder mappings(Map<String, IndexMappingRecord> map) {
            this.mappings = Builder._mapPutAll(this.mappings, map);
            return this;
        }

        public final Builder mappings(String key, IndexMappingRecord value) {
            this.mappings = Builder._mapPut(this.mappings, key, value);
            return this;
        }

        public final Builder mappings(String key, Function<IndexMappingRecord.Builder, ObjectBuilder<IndexMappingRecord>> fn) {
            return this.mappings(key, fn.apply(new IndexMappingRecord.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            Map<String, IndexMappingRecord> value = JsonpDeserializer.stringMapDeserializer(IndexMappingRecord._DESERIALIZER).deserialize(parser, mapper);
            return this.mappings(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetMappingResponse build() {
            this._checkSingleUse();
            return new GetMappingResponse(this);
        }
    }
}

